/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.rebalance;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.rebalance.RaftCommandWithRetry;
import org.apache.ignite3.internal.raft.service.RaftGroupService;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteBusyLock;
import org.jetbrains.annotations.Nullable;

public class ChangePeersAndLearnersWithRetry {
    private final RaftCommandWithRetry raftCommand;
    private final Supplier<CompletableFuture<RaftGroupService>> raftGroupServiceSupplier;

    public ChangePeersAndLearnersWithRetry(IgniteBusyLock busyLock, ScheduledExecutorService rebalanceScheduler, Supplier<CompletableFuture<RaftGroupService>> raftGroupServiceSupplier) {
        this.raftGroupServiceSupplier = raftGroupServiceSupplier;
        this.raftCommand = new RaftCommandWithRetry(busyLock, rebalanceScheduler);
    }

    public CompletableFuture<Void> execute(PeersAndLearners peersAndLearners, long sequenceToken, Function<RaftGroupService, CompletableFuture<@Nullable IgniteBiTuple<RaftGroupService, Long>>> leaderFilter) {
        return this.raftCommand.execute(() -> ((CompletableFuture)this.raftGroupServiceSupplier.get().thenCompose(leaderFilter)).thenCompose(raftWithTerm -> {
            if (raftWithTerm == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            RaftGroupService raftClient = (RaftGroupService)raftWithTerm.get1();
            assert (raftClient != null);
            Long term = (Long)raftWithTerm.get2();
            assert (term != null);
            return raftClient.changePeersAndLearnersAsync(peersAndLearners, term, sequenceToken);
        }));
    }

    public CompletableFuture<Void> executeOnLeader(PeersAndLearners peersAndLearners, long term, long sequenceToken) {
        return this.execute(peersAndLearners, sequenceToken, raftClient -> CompletableFuture.completedFuture(new IgniteBiTuple<RaftGroupService, Long>((RaftGroupService)raftClient, term)));
    }
}

