/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.configuration;

import org.apache.ignite3.configuration.annotation.Config;
import org.apache.ignite3.configuration.annotation.Value;
import org.apache.ignite3.configuration.validation.Range;

@Config
public class LogStorageConfigurationSchema {
    public static final int DEFAULT_MAX_CHECKPOINT_QUEUE_SIZE = 10;
    public static final int DEFAULT_SEGMENT_FILE_SIZE_BYTES = Integer.MAX_VALUE;
    public static final int UNSPECIFIED_MAX_LOG_ENTRY_SIZE = -1;
    @Value(hasDefault=true)
    @Range(min=1L)
    public int maxCheckpointQueueSize = 10;
    @Value(hasDefault=true)
    @Range(min=4096L, max=0x7FFFFFFFL)
    public long segmentFileSizeBytes = Integer.MAX_VALUE;
    @Value(hasDefault=true)
    public int maxLogEntrySizeBytes = -1;

    public static int computeDefaultMaxLogEntrySizeBytes(long segmentFileSizeBytes) {
        long maxAllowedEntrySize = (long)((double)segmentFileSizeBytes * 0.9);
        return (int)Math.min(Integer.MAX_VALUE, maxAllowedEntrySize);
    }
}

