/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft;

import java.io.Serializable;
import org.apache.ignite3.internal.tostring.S;

public final class Peer
implements Serializable {
    private static final long serialVersionUID = 6140534113821565486L;
    private final String consistentId;
    private final int idx;

    public Peer(String consistentId) {
        this(consistentId, 0);
    }

    public Peer(String consistentId, int idx) {
        this.consistentId = consistentId;
        this.idx = idx;
    }

    public String consistentId() {
        return this.consistentId;
    }

    public int idx() {
        return this.idx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Peer peer = (Peer)o;
        if (this.idx != peer.idx) {
            return false;
        }
        return this.consistentId.equals(peer.consistentId);
    }

    public int hashCode() {
        int result = this.consistentId.hashCode();
        result = 31 * result + this.idx;
        return result;
    }

    public String toString() {
        return S.toString(Peer.class, this);
    }
}

