/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.Revisions;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite3.internal.placementdriver.AssignmentsTracker;
import org.apache.ignite3.internal.placementdriver.LeaseUpdater;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.placementdriver.ReplicaMeta;
import org.apache.ignite3.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite3.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite3.internal.placementdriver.leases.LeaseTracker;
import org.apache.ignite3.internal.placementdriver.metrics.PlacementDriverMetricSource;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.RaftManager;
import org.apache.ignite3.internal.raft.StoppingExceptionFactories;
import org.apache.ignite3.internal.raft.client.TopologyAwareRaftGroupService;
import org.apache.ignite3.internal.raft.client.TopologyAwareRaftGroupServiceFactory;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.configuration.ReplicationConfiguration;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteBusyLock;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.TestOnly;

public class PlacementDriverManager
implements IgniteComponent {
    private static final String PLACEMENTDRIVER_LEASES_KEY_STRING = "placementdriver.leases";
    public static final ByteArray PLACEMENTDRIVER_LEASES_KEY = ByteArray.fromString("placementdriver.leases");
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final ClusterService clusterService;
    private final ReplicationGroupId replicationGroupId;
    private final Supplier<CompletableFuture<Set<String>>> placementDriverNodesNamesProvider;
    private final RaftManager raftManager;
    private final TopologyAwareRaftGroupServiceFactory topologyAwareRaftGroupServiceFactory;
    private final CompletableFuture<TopologyAwareRaftGroupService> raftClientFuture;
    private final LeaseTracker leaseTracker;
    private final LeaseUpdater leaseUpdater;
    private final MetaStorageManager metastore;
    private final FailureProcessor failureProcessor;
    private final AssignmentsTracker assignmentsTracker;
    private final PlacementDriver placementDriver;
    private final MetricManager metricManager;
    private final PlacementDriverMetricSource metricSource;

    public PlacementDriverManager(String nodeName, MetaStorageManager metastore, ReplicationGroupId replicationGroupId, ClusterService clusterService, Supplier<CompletableFuture<Set<String>>> placementDriverNodesNamesProvider, LogicalTopologyService logicalTopologyService, RaftManager raftManager, TopologyAwareRaftGroupServiceFactory topologyAwareRaftGroupServiceFactory, ClockService clockService, FailureProcessor failureProcessor, ReplicationConfiguration replicationConfiguration, Executor throttledLogExecutor, MetricManager metricManager, Function<Integer, CompletableFuture<Set<String>>> currentDataNodesProvider) {
        this.replicationGroupId = replicationGroupId;
        this.clusterService = clusterService;
        this.placementDriverNodesNamesProvider = placementDriverNodesNamesProvider;
        this.raftManager = raftManager;
        this.topologyAwareRaftGroupServiceFactory = topologyAwareRaftGroupServiceFactory;
        this.metastore = metastore;
        this.failureProcessor = failureProcessor;
        this.raftClientFuture = new CompletableFuture();
        this.leaseTracker = new LeaseTracker(metastore, clusterService.topologyService(), clockService, currentDataNodesProvider);
        this.assignmentsTracker = new AssignmentsTracker(metastore, failureProcessor, currentDataNodesProvider);
        this.leaseUpdater = new LeaseUpdater(nodeName, clusterService, metastore, failureProcessor, logicalTopologyService, this.leaseTracker, clockService, this.assignmentsTracker, replicationConfiguration, throttledLogExecutor);
        this.placementDriver = this.createPlacementDriver();
        this.metricManager = metricManager;
        this.metricSource = new PlacementDriverMetricSource(this.leaseTracker, this.assignmentsTracker);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            ((CompletableFuture)this.placementDriverNodesNamesProvider.get().thenCompose(placementDriverNodes -> {
                String thisNodeName = this.clusterService.topologyService().localMember().name();
                if (!placementDriverNodes.contains(thisNodeName)) {
                    return CompletableFutures.nullCompletedFuture();
                }
                try {
                    this.leaseUpdater.init();
                    TopologyAwareRaftGroupService raftClient = this.raftManager.startRaftGroupService(this.replicationGroupId, PeersAndLearners.fromConsistentIds(placementDriverNodes), this.topologyAwareRaftGroupServiceFactory, null, StoppingExceptionFactories.indicateNodeStop(), true);
                    return raftClient.subscribeLeader(this::onLeaderChange).thenApply(v -> raftClient);
                }
                catch (NodeStoppingException e) {
                    return CompletableFuture.failedFuture(e);
                }
            })).whenComplete((client, ex) -> {
                if (ex == null) {
                    this.raftClientFuture.complete((TopologyAwareRaftGroupService)client);
                } else {
                    if (!ExceptionUtils.hasCause(ex, NodeStoppingException.class)) {
                        this.failureProcessor.process(new FailureContext((Throwable)ex, "Placement driver initialization exception"));
                    }
                    this.raftClientFuture.completeExceptionally((Throwable)ex);
                }
            });
            this.recoverInternalComponentsBusy();
            this.metricManager.registerSource(this.metricSource);
            this.metricManager.enable("placement-driver");
        });
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void beforeNodeStop() {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            this.withRaftClientIfPresent(c -> {
                c.unsubscribeLeader().join();
                this.leaseUpdater.deInit();
            });
            this.assignmentsTracker.stopTrack();
            this.leaseTracker.stopTrack();
        });
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.withRaftClientIfPresent(TopologyAwareRaftGroupService::shutdown);
        this.leaseUpdater.deactivate();
        this.metricManager.disable("placement-driver");
        return CompletableFutures.nullCompletedFuture();
    }

    private void withRaftClientIfPresent(Consumer<TopologyAwareRaftGroupService> closure) {
        this.raftClientFuture.thenAccept(client -> {
            if (client != null) {
                closure.accept((TopologyAwareRaftGroupService)client);
            }
        });
    }

    private void onLeaderChange(InternalClusterNode leader, long term) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            if (leader.equals(this.clusterService.topologyService().localMember())) {
                this.takeOverActiveActorBusy();
            } else {
                this.stepDownActiveActorBusy();
            }
        });
    }

    private void takeOverActiveActorBusy() {
        this.leaseUpdater.activate();
    }

    private void stepDownActiveActorBusy() {
        this.leaseUpdater.deactivate();
    }

    @TestOnly
    boolean isActiveActor() {
        return this.leaseUpdater.active();
    }

    public PlacementDriver placementDriver() {
        return this.placementDriver;
    }

    private void recoverInternalComponentsBusy() {
        CompletableFuture<Revisions> recoveryFinishedFuture = this.metastore.recoveryFinishedFuture();
        assert (recoveryFinishedFuture.isDone());
        long recoveryRevision = recoveryFinishedFuture.join().revision();
        this.assignmentsTracker.startTrack();
        this.leaseTracker.startTrack(recoveryRevision);
    }

    private PlacementDriver createPlacementDriver() {
        return new PlacementDriver(){

            @Override
            public boolean isActualAt(HybridTimestamp timestamp) {
                return PlacementDriverManager.this.metastore.clusterTime().currentSafeTime().compareTo(timestamp) >= 0;
            }

            @Override
            public CompletableFuture<List<TokenizedAssignments>> getAssignments(List<? extends ReplicationGroupId> replicationGroupIds, HybridTimestamp timestamp) {
                return PlacementDriverManager.this.assignmentsTracker.getAssignments(replicationGroupIds, timestamp);
            }

            @Override
            public CompletableFuture<List<TokenizedAssignments>> awaitNonEmptyAssignments(List<? extends ReplicationGroupId> replicationGroupIds, HybridTimestamp clusterTimeToAwait, long timeoutMillis) {
                return PlacementDriverManager.this.assignmentsTracker.awaitNonEmptyAssignments(replicationGroupIds, clusterTimeToAwait, timeoutMillis);
            }

            @Override
            public CompletableFuture<ReplicaMeta> awaitPrimaryReplica(ReplicationGroupId groupId, HybridTimestamp timestamp, long timeout, TimeUnit unit) {
                return PlacementDriverManager.this.leaseTracker.awaitPrimaryReplica(groupId, timestamp, timeout, unit);
            }

            @Override
            public CompletableFuture<ReplicaMeta> getPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
                return PlacementDriverManager.this.leaseTracker.getPrimaryReplica(replicationGroupId, timestamp);
            }

            @Override
            public ReplicaMeta getCurrentPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
                return PlacementDriverManager.this.leaseTracker.getCurrentPrimaryReplica(replicationGroupId, timestamp);
            }

            @Override
            public CompletableFuture<Void> previousPrimaryExpired(ReplicationGroupId replicationGroupId) {
                return PlacementDriverManager.this.leaseTracker.previousPrimaryExpired(replicationGroupId);
            }

            @Override
            public void listen(PrimaryReplicaEvent evt, EventListener<? extends PrimaryReplicaEventParameters> listener) {
                PlacementDriverManager.this.leaseTracker.listen(evt, listener);
            }

            @Override
            public void removeListener(PrimaryReplicaEvent evt, EventListener<? extends PrimaryReplicaEventParameters> listener) {
                PlacementDriverManager.this.leaseTracker.removeListener(evt, listener);
            }
        };
    }
}

