/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.snapshot.outgoing;

import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.SnapshotUri;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.metrics.RaftSnapshotsMetricsSource;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.outgoing.OutgoingSnapshot;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.storage.snapshot.SnapshotReader;

public class OutgoingSnapshotReader
extends SnapshotReader {
    private static final IgniteLogger LOG = Loggers.forClass(OutgoingSnapshotReader.class);
    private final UUID id;
    private final PartitionSnapshotStorage snapshotStorage;
    private final OutgoingSnapshot snapshot;

    public OutgoingSnapshotReader(UUID snapshotId, PartitionSnapshotStorage snapshotStorage, RaftSnapshotsMetricsSource snapshotMetricsSource) {
        this.snapshotStorage = snapshotStorage;
        this.id = snapshotId;
        this.snapshot = new OutgoingSnapshot(this.id, snapshotStorage.partitionKey(), snapshotStorage.partitionsByTableId(), snapshotStorage.txState(), snapshotStorage.catalogService(), snapshotMetricsSource);
        LOG.info("Starting snapshot reader [{}, snapshotId={}]", this.createPartitionInfo(), this.id);
        snapshotStorage.outgoingSnapshotsManager().startOutgoingSnapshot(this.id, this.snapshot);
    }

    @Override
    public RaftOutter.SnapshotMeta load() {
        return this.snapshot.meta();
    }

    @Override
    public String generateURIForCopy() {
        String localNodeName = this.snapshotStorage.topologyService().localMember().name();
        return SnapshotUri.toStringUri(this.id, localNodeName);
    }

    @Override
    public void close() throws IOException {
        LOG.info("Closing snapshot reader [{}, snapshotId={}]", this.createPartitionInfo(), this.id);
        this.snapshotStorage.outgoingSnapshotsManager().finishOutgoingSnapshot(this.id);
    }

    @Override
    public boolean init(Void opts) {
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getPath() {
        throw new UnsupportedOperationException("No path for the rebalance snapshot");
    }

    @Override
    public Set<String> listFiles() {
        return Set.of();
    }

    @Override
    public Message getFileMeta(String fileName) {
        throw new UnsupportedOperationException("No files in the snapshot");
    }

    private String createPartitionInfo() {
        return this.snapshotStorage.partitionKey().toString();
    }
}

