/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.snapshot.incoming;

import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.metrics.StopWatchTimer;

class IncomingSnapshotStats {
    private long totalMvRows;
    private int totalMvBatches;
    private long totalTxMetas;
    private int totalTxMetasBatches;
    private final StopWatchTimer loadSnapshotMetaTimer = new StopWatchTimer();
    private final StopWatchTimer waitingCatalogTimer = new StopWatchTimer();
    private final StopWatchTimer preparingStoragesTimer = new StopWatchTimer();
    private final StopWatchTimer loadMvDataTimer = new StopWatchTimer();
    private final StopWatchTimer loadTxDataTimer = new StopWatchTimer();
    private final StopWatchTimer setRowIdToBuildIndexTimer = new StopWatchTimer();
    private final StopWatchTimer totalSnapshotInstallationTimer = new StopWatchTimer();

    IncomingSnapshotStats() {
    }

    void onMvBatchProcessing(long rows) {
        this.totalMvRows += rows;
        ++this.totalMvBatches;
    }

    void onLoadMvDataPhaseStart() {
        this.loadMvDataTimer.start();
    }

    void onLoadMvDataPhaseEnd() {
        this.loadMvDataTimer.end();
    }

    long totalMvDataRows() {
        return this.totalMvRows;
    }

    long totalMvDataBatches() {
        return this.totalMvBatches;
    }

    long loadMvDataPhaseDuration() {
        return this.loadMvDataTimer.duration(TimeUnit.MILLISECONDS);
    }

    void onTxMetasBatchProcessing(long metas) {
        this.totalTxMetas += metas;
        ++this.totalTxMetasBatches;
    }

    void onLoadTxMetasPhaseStart() {
        this.loadTxDataTimer.start();
    }

    void onLoadTxMetasPhaseEnd() {
        this.loadTxDataTimer.end();
    }

    long totalTxMetas() {
        return this.totalTxMetas;
    }

    long totalTxMetasBatches() {
        return this.totalTxMetasBatches;
    }

    long loadTxMetasPhaseDuration() {
        return this.loadTxDataTimer.duration(TimeUnit.MILLISECONDS);
    }

    void onSnapshotInstallationStart() {
        this.totalSnapshotInstallationTimer.start();
    }

    void onSnapshotInstallationEnd() {
        this.totalSnapshotInstallationTimer.end();
    }

    long totalSnapshotInstallationDuration() {
        return this.totalSnapshotInstallationTimer.duration(TimeUnit.MILLISECONDS);
    }

    void onLoadSnapshotPhaseStart() {
        this.loadSnapshotMetaTimer.start();
    }

    void onLoadSnapshotPhaseEnd() {
        this.loadSnapshotMetaTimer.end();
    }

    long totalLoadSnapshotPhaseDuration() {
        return this.loadSnapshotMetaTimer.duration(TimeUnit.MILLISECONDS);
    }

    void onWaitingCatalogPhaseStart() {
        this.waitingCatalogTimer.start();
    }

    void onWaitingCatalogPhaseEnd() {
        this.waitingCatalogTimer.end();
    }

    long totalWaitingCatalogPhaseDuration() {
        return this.waitingCatalogTimer.duration(TimeUnit.MILLISECONDS);
    }

    void onPreparingStoragePhaseStart() {
        this.preparingStoragesTimer.start();
    }

    void onPreparingStoragePhaseEnd() {
        this.preparingStoragesTimer.end();
    }

    long totalPreparingStoragePhaseDuration() {
        return this.preparingStoragesTimer.duration(TimeUnit.MILLISECONDS);
    }

    void onSetRowIdToBuildPhaseStart() {
        this.setRowIdToBuildIndexTimer.start();
    }

    void onSetRowIdToBuildPhaseEnd() {
        this.setRowIdToBuildIndexTimer.end();
    }

    long totalSetRowIdToBuildPhaseDuration() {
        return this.setRowIdToBuildIndexTimer.duration(TimeUnit.MILLISECONDS);
    }
}

