/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.UserDetailsMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequestV2;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequestV2Builder;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class ReadOnlySingleRowPkReplicaRequestV2Deserializer
implements MessageDeserializer<ReadOnlySingleRowPkReplicaRequestV2> {
    private final ReadOnlySingleRowPkReplicaRequestV2Builder msg;

    ReadOnlySingleRowPkReplicaRequestV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readOnlySingleRowPkReplicaRequestV2();
    }

    @Override
    public Class<ReadOnlySingleRowPkReplicaRequestV2> klass() {
        return ReadOnlySingleRowPkReplicaRequestV2.class;
    }

    @Override
    public ReadOnlySingleRowPkReplicaRequestV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readOnlySingleRowPkReplicaRequestV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.coordinatorId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readByteBuffer("primaryKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.primaryKey((ByteBuffer)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readHybridTimestamp("readTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.readTimestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                RequestType tmp;
                int shiftedId = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType requestType = tmp = shiftedId == 0 ? null : RequestType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.requestType(tmp);
                }
                reader.incrementState();
            }
            case 5: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 6: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 7: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 8: {
                Comparable<HybridTimestamp> tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transactionId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 9: {
                boolean tmp = reader.readBoolean("usePrimary");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.usePrimary(tmp);
                reader.incrementState();
            }
            case 10: {
                UserDetailsMessage tmp = (UserDetailsMessage)reader.readMessage("userDetails");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.userDetails(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadOnlySingleRowPkReplicaRequestV2.class);
    }
}

