/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyRowVersionsScanRetrieveBatchReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestSerializer;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl
implements ReadOnlyRowVersionsScanRetrieveBatchReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16375;
    @IgniteToStringInclude
    private final int batchSize;
    @IgniteToStringInclude
    private final UUID coordinatorId;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final UUID lowerBoundRowId;
    @IgniteToStringInclude
    private final HybridTimestamp lowerBoundTimestamp;
    @IgniteToStringInclude
    private final HybridTimestamp readTimestamp;
    @IgniteToStringInclude
    private final long scanId;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID transactionId;
    @IgniteToStringInclude
    private final boolean usePrimary;

    private ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl(int batchSize, UUID coordinatorId, ReplicationGroupIdMessage groupId, UUID lowerBoundRowId, HybridTimestamp lowerBoundTimestamp, HybridTimestamp readTimestamp, long scanId, int tableId, HybridTimestamp timestamp, UUID transactionId, boolean usePrimary) {
        this.batchSize = batchSize;
        this.coordinatorId = coordinatorId;
        this.groupId = groupId;
        this.lowerBoundRowId = lowerBoundRowId;
        this.lowerBoundTimestamp = lowerBoundTimestamp;
        this.readTimestamp = readTimestamp;
        this.scanId = scanId;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
        this.usePrimary = usePrimary;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public UUID lowerBoundRowId() {
        return this.lowerBoundRowId;
    }

    @Override
    public HybridTimestamp lowerBoundTimestamp() {
        return this.lowerBoundTimestamp;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public long scanId() {
        return this.scanId;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    @Override
    public boolean usePrimary() {
        return this.usePrimary;
    }

    public MessageSerializer serializer() {
        return ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 16375;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl otherMessage = (ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl)other;
        return Objects.equals(this.coordinatorId, otherMessage.coordinatorId) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.lowerBoundRowId, otherMessage.lowerBoundRowId) && Objects.equals(this.lowerBoundTimestamp, otherMessage.lowerBoundTimestamp) && Objects.equals(this.readTimestamp, otherMessage.readTimestamp) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && this.batchSize == otherMessage.batchSize && this.scanId == otherMessage.scanId && this.tableId == otherMessage.tableId && this.usePrimary == otherMessage.usePrimary;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchSize, this.scanId, this.tableId, this.usePrimary, this.coordinatorId, this.groupId, this.lowerBoundRowId, this.lowerBoundTimestamp, this.readTimestamp, this.timestamp, this.transactionId);
        return result;
    }

    @Override
    public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl clone() {
        try {
            return (ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder {
        private int batchSize;
        private UUID coordinatorId;
        private ReplicationGroupIdMessage groupId;
        private UUID lowerBoundRowId;
        private HybridTimestamp lowerBoundTimestamp;
        private HybridTimestamp readTimestamp;
        private long scanId;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID transactionId;
        private boolean usePrimary;

        private Builder() {
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder coordinatorId(UUID coordinatorId) {
            this.coordinatorId = coordinatorId;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder lowerBoundRowId(UUID lowerBoundRowId) {
            Objects.requireNonNull(lowerBoundRowId, "lowerBoundRowId is not marked @Nullable");
            this.lowerBoundRowId = lowerBoundRowId;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder lowerBoundTimestamp(HybridTimestamp lowerBoundTimestamp) {
            Objects.requireNonNull(lowerBoundTimestamp, "lowerBoundTimestamp is not marked @Nullable");
            this.lowerBoundTimestamp = lowerBoundTimestamp;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder readTimestamp(HybridTimestamp readTimestamp) {
            Objects.requireNonNull(readTimestamp, "readTimestamp is not marked @Nullable");
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder scanId(long scanId) {
            this.scanId = scanId;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder transactionId(UUID transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestBuilder usePrimary(boolean usePrimary) {
            this.usePrimary = usePrimary;
            return this;
        }

        @Override
        public int batchSize() {
            return this.batchSize;
        }

        @Override
        public UUID coordinatorId() {
            return this.coordinatorId;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public UUID lowerBoundRowId() {
            return this.lowerBoundRowId;
        }

        @Override
        public HybridTimestamp lowerBoundTimestamp() {
            return this.lowerBoundTimestamp;
        }

        @Override
        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        @Override
        public long scanId() {
            return this.scanId;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public boolean usePrimary() {
            return this.usePrimary;
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequest build() {
            return new ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl(this.batchSize, this.coordinatorId, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.lowerBoundRowId, "lowerBoundRowId is not marked @Nullable"), Objects.requireNonNull(this.lowerBoundTimestamp, "lowerBoundTimestamp is not marked @Nullable"), Objects.requireNonNull(this.readTimestamp, "readTimestamp is not marked @Nullable"), this.scanId, this.tableId, this.timestamp, this.transactionId, this.usePrimary);
        }

        @Override
        public ReadOnlyRowVersionsScanRetrieveBatchReplicaRequest buildDeserialized() {
            return new ReadOnlyRowVersionsScanRetrieveBatchReplicaRequestImpl(this.batchSize, this.coordinatorId, this.groupId, this.lowerBoundRowId, this.lowerBoundTimestamp, this.readTimestamp, this.scanId, this.tableId, this.timestamp, this.transactionId, this.usePrimary);
        }
    }
}

