/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.UserDetailsMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequestV2;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequestV2Builder;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class ReadOnlyDirectSingleRowReplicaRequestV2Deserializer
implements MessageDeserializer<ReadOnlyDirectSingleRowReplicaRequestV2> {
    private final ReadOnlyDirectSingleRowReplicaRequestV2Builder msg;

    ReadOnlyDirectSingleRowReplicaRequestV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readOnlyDirectSingleRowReplicaRequestV2();
    }

    @Override
    public Class<ReadOnlyDirectSingleRowReplicaRequestV2> klass() {
        return ReadOnlyDirectSingleRowReplicaRequestV2.class;
    }

    @Override
    public ReadOnlyDirectSingleRowReplicaRequestV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readOnlyDirectSingleRowReplicaRequestV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistmentConsistencyToken((Long)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readByteBuffer("primaryKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.primaryKey((ByteBuffer)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                RequestType tmp;
                int shiftedId = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType requestType = tmp = shiftedId == 0 ? null : RequestType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.requestType(tmp);
                }
                reader.incrementState();
            }
            case 4: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 5: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 7: {
                Object tmp = (UserDetailsMessage)reader.readMessage("userDetails");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.userDetails((UserDetailsMessage)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadOnlyDirectSingleRowReplicaRequestV2.class);
    }
}

