/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.raft;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.raft.ResponseEntryImpl;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotMvDataResponse;

class ResponseEntrySerializer
implements MessageSerializer<SnapshotMvDataResponse.ResponseEntry> {
    public static final ResponseEntrySerializer INSTANCE = new ResponseEntrySerializer();

    private ResponseEntrySerializer() {
    }

    @Override
    public boolean writeMessage(SnapshotMvDataResponse.ResponseEntry msg, MessageWriter writer) throws MessageMappingException {
        ResponseEntryImpl message = (ResponseEntryImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.responseEntry());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)7)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("commitPartitionId", message.commitPartitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeBoxedInt("commitTableOrZoneId", message.commitTableOrZoneId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeUuid("rowId", message.rowId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeList("rowVersions", message.rowVersions(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeLongArray("timestamps", message.timestamps());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

