/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.disaster;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.disaster.OperationCompletedMessage;
import org.apache.ignite3.internal.partition.replicator.network.disaster.OperationCompletedMessageImpl;

class OperationCompletedMessageSerializer
implements MessageSerializer<OperationCompletedMessage> {
    public static final OperationCompletedMessageSerializer INSTANCE = new OperationCompletedMessageSerializer();

    private OperationCompletedMessageSerializer() {
    }

    @Override
    public boolean writeMessage(OperationCompletedMessage msg, MessageWriter writer) throws MessageMappingException {
        OperationCompletedMessageImpl message = (OperationCompletedMessageImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.operationCompletedMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("exceptionMessage", message.exceptionMessage());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("operationId", message.operationId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

