/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.command.TransferRowVersionsToSecondaryStorageCommand;
import org.apache.ignite3.internal.partition.replicator.network.command.TransferRowVersionsToSecondaryStorageCommandBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;

class TransferRowVersionsToSecondaryStorageCommandDeserializer
implements MessageDeserializer<TransferRowVersionsToSecondaryStorageCommand> {
    private final TransferRowVersionsToSecondaryStorageCommandBuilder msg;

    TransferRowVersionsToSecondaryStorageCommandDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.transferRowVersionsToSecondaryStorageCommand();
    }

    @Override
    public Class<TransferRowVersionsToSecondaryStorageCommand> klass() {
        return TransferRowVersionsToSecondaryStorageCommand.class;
    }

    @Override
    public TransferRowVersionsToSecondaryStorageCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.transferRowVersionsToSecondaryStorageCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.leaseStartTime(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readList("rows", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.rows((List<BinaryRowWithTombstoneMessage>)((Object)tmp));
                }
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TransferRowVersionsToSecondaryStorageCommand.class);
    }
}

