/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommandV2;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommandV2Builder;

class BuildIndexCommandV2Deserializer
implements MessageDeserializer<BuildIndexCommandV2> {
    private final BuildIndexCommandV2Builder msg;

    BuildIndexCommandV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.buildIndexCommandV2();
    }

    @Override
    public Class<BuildIndexCommandV2> klass() {
        return BuildIndexCommandV2.class;
    }

    @Override
    public BuildIndexCommandV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.buildIndexCommandV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readBoolean("finish");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.finish(tmp != 0);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("indexId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.indexId(tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("rowIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.rowIds((List<UUID>)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BuildIndexCommandV2.class);
    }
}

