/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.handlers;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.ClusterNodeResolver;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.RecipientLeftException;
import org.apache.ignite3.internal.partition.replicator.TxRecoveryEngine;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tx.TransactionMeta;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.TxMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.TxStateMeta;
import org.apache.ignite3.internal.tx.TxStateMetaFinishing;
import org.apache.ignite3.internal.tx.impl.TxMessageSender;
import org.apache.ignite3.internal.tx.message.TxStateCommitPartitionRequest;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.jetbrains.annotations.Nullable;

public class TxStateCommitPartitionReplicaRequestHandler {
    private final TxStatePartitionStorage txStatePartitionStorage;
    private final TxManager txManager;
    private final ClusterNodeResolver clusterNodeResolver;
    private final InternalClusterNode localNode;
    private final TxRecoveryEngine txRecoveryEngine;
    private final TxMessageSender txMessageSender;

    public TxStateCommitPartitionReplicaRequestHandler(TxStatePartitionStorage txStatePartitionStorage, TxManager txManager, ClusterNodeResolver clusterNodeResolver, InternalClusterNode localNode, TxRecoveryEngine txRecoveryEngine, TxMessageSender txMessageSender) {
        this.txStatePartitionStorage = txStatePartitionStorage;
        this.txManager = txManager;
        this.clusterNodeResolver = clusterNodeResolver;
        this.localNode = localNode;
        this.txRecoveryEngine = txRecoveryEngine;
        this.txMessageSender = txMessageSender;
    }

    public CompletableFuture<TransactionMeta> handle(TxStateCommitPartitionRequest request) {
        UUID txId = request.txId();
        TxStateMeta txMeta = this.txManager.stateMeta(txId);
        if (txMeta != null && txMeta.txState() == TxState.FINISHING) {
            assert (txMeta instanceof TxStateMetaFinishing) : txMeta;
            return ((TxStateMetaFinishing)txMeta).txFinishFuture();
        }
        if (txMeta == null || !TxState.isFinalState(txMeta.txState())) {
            ZonePartitionId zonePartitionId = request.senderGroupId() == null ? null : request.senderGroupId().asReplicationGroupId();
            return this.triggerTxRecoveryOnTxStateResolutionIfNeeded(txId, txMeta, request.readTimestamp(), request.senderCurrentConsistencyToken(), zonePartitionId);
        }
        return CompletableFuture.completedFuture(txMeta);
    }

    private CompletableFuture<TransactionMeta> triggerTxRecoveryOnTxStateResolutionIfNeeded(UUID txId, @Nullable TxStateMeta txStateMeta, @Nullable HybridTimestamp readTimestamp, @Nullable Long senderCurrentConsistencyToken, @Nullable ZonePartitionId senderGroupId) {
        assert (txStateMeta == null || txStateMeta.txState() == TxState.PENDING || txStateMeta.txState() == TxState.ABANDONED) : "Unexpected transaction state: " + txStateMeta;
        TxMeta txMeta = this.txStatePartitionStorage.get(txId);
        if (txMeta == null) {
            InternalClusterNode coordinator;
            InternalClusterNode internalClusterNode = coordinator = txStateMeta == null || txStateMeta.txCoordinatorId() == null ? null : this.clusterNodeResolver.getById(txStateMeta.txCoordinatorId());
            if (txStateMeta == null || txStateMeta.txState() == TxState.ABANDONED || txStateMeta.txCoordinatorId() == null || coordinator == null) {
                return ((CompletableFuture)this.txRecoveryEngine.triggerTxRecovery(txId, this.localNode.id()).handle((T v, U ex) -> CompletableFuture.completedFuture(this.txManager.stateMeta(txId)))).thenCompose(Function.identity());
            }
            if (coordinator != null) {
                HybridTimestamp timestamp = readTimestamp == null ? HybridTimestamp.MIN_VALUE : readTimestamp;
                return ((CompletableFuture)this.txMessageSender.resolveTxStateFromCoordinator(coordinator, txId, timestamp, senderCurrentConsistencyToken, senderGroupId).handle((T response, U e) -> {
                    if (e == null) {
                        if (response.txStateMeta() == null) {
                            return CompletableFuture.completedFuture(TxStateMeta.builder(TxState.PENDING).build());
                        }
                        return CompletableFuture.completedFuture(response.txStateMeta().asTransactionMeta());
                    }
                    if (e.getCause() instanceof RecipientLeftException) {
                        this.markAbandoned(txId);
                    }
                    return ((CompletableFuture)this.txRecoveryEngine.triggerTxRecovery(txId, this.localNode.id()).handle((T v, U ex) -> CompletableFuture.completedFuture(this.txManager.stateMeta(txId)))).thenCompose(Function.identity());
                })).thenCompose(Function.identity());
            }
            assert (txStateMeta != null && txStateMeta.txState() == TxState.PENDING) : "Unexpected transaction state: " + txStateMeta;
            return CompletableFuture.completedFuture(txStateMeta);
        }
        assert (TxState.isFinalState(txMeta.txState())) : "Unexpected transaction state: " + txMeta;
        return CompletableFuture.completedFuture(txMeta);
    }

    private void markAbandoned(UUID txId) {
        this.txManager.updateTxMeta(txId, stateMeta -> stateMeta != null ? stateMeta.abandoned() : null);
    }
}

