/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.TxStateMeta;
import org.jetbrains.annotations.Nullable;

public class ReplicaTxFinishMarker {
    private final TxManager txManager;

    public ReplicaTxFinishMarker(TxManager txManager) {
        this.txManager = txManager;
    }

    public void markFinished(UUID txId, TxState txState, @Nullable HybridTimestamp commitTimestamp) {
        assert (TxState.isFinalState(txState)) : "Unexpected state [txId=" + txId + ", txState=" + txState + "]";
        this.txManager.updateTxMeta(txId, old -> TxStateMeta.builder(old, txState).commitTimestamp(txState == TxState.COMMITTED ? commitTimestamp : null).build());
    }
}

