/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.checkpoint;

import org.apache.ignite3.internal.metrics.DistributionMetric;
import org.apache.ignite3.internal.metrics.LongAdderMetric;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointMetricSource;

public class CheckpointReadWriteLockMetrics {
    private static final long[] LOCK_ACQUISITION_BOUNDS_NANOS = new long[]{1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L};
    private static final long[] LOCK_HOLD_BOUNDS_NANOS = new long[]{1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L};
    private final DistributionMetric readLockAcquisitionTime = new DistributionMetric("ReadLockAcquisitionTime", "Time from requesting checkpoint read lock until acquisition in nanoseconds.", LOCK_ACQUISITION_BOUNDS_NANOS);
    private final DistributionMetric readLockHoldTime = new DistributionMetric("ReadLockHoldTime", "Duration between checkpoint read lock acquisition and release in nanoseconds.", LOCK_HOLD_BOUNDS_NANOS);
    private final LongAdderMetric readLockWaitingThreads = new LongAdderMetric("ReadLockWaitingThreads", "Current number of threads waiting for checkpoint read lock.");

    public CheckpointReadWriteLockMetrics(CheckpointMetricSource metricSource) {
        metricSource.addMetric(this.readLockAcquisitionTime);
        metricSource.addMetric(this.readLockHoldTime);
        metricSource.addMetric(this.readLockWaitingThreads);
    }

    public void recordReadLockAcquisitionTime(long acquisitionDurationNanos) {
        this.readLockAcquisitionTime.add(acquisitionDurationNanos);
    }

    public void recordReadLockHoldDuration(long lockHoldDurationNanos) {
        this.readLockHoldTime.add(lockHoldDurationNanos);
    }

    public void incrementReadLockWaitingThreads() {
        this.readLockWaitingThreads.increment();
    }

    public void decrementReadLockWaitingThreads() {
        this.readLockWaitingThreads.decrement();
    }

    DistributionMetric readLockAcquisitionTime() {
        return this.readLockAcquisitionTime;
    }

    DistributionMetric readLockHoldTime() {
        return this.readLockHoldTime;
    }

    LongAdderMetric readLockWaitingThreads() {
        return this.readLockWaitingThreads;
    }
}

