/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.checkpoint;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.pagememory.persistence.DirtyFullPageId;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.Nullable;

class CheckpointPageReplacement {
    private final Set<DirtyFullPageId> pageIds = ConcurrentHashMap.newKeySet();
    private final CompletableFuture<Void> stopBlockingFuture = new CompletableFuture();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    CheckpointPageReplacement() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void block(DirtyFullPageId pageId) {
        boolean enterBusy = this.busyLock.enterBusy();
        assert (enterBusy) : "Method should not be invoked after the fsync phase has started for any page: " + pageId;
        try {
            boolean added = this.pageIds.add(pageId);
            assert (added) : "Page is already in the process of being replaced: " + pageId;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    void unblock(DirtyFullPageId pageId, @Nullable Throwable error) {
        boolean removed = this.pageIds.remove(pageId);
        assert (removed) : "Replacement for the page either did not start or ended: " + pageId;
        if (error != null) {
            this.stopBlockingFuture.completeExceptionally(error);
            return;
        }
        if (!this.busyLock.enterBusy()) {
            if (this.pageIds.isEmpty()) {
                this.stopBlockingFuture.complete(null);
            }
        } else {
            this.busyLock.leaveBusy();
        }
    }

    CompletableFuture<Void> stopBlocking() {
        if (this.stopGuard.compareAndSet(false, true)) {
            this.busyLock.block();
        }
        if (this.pageIds.isEmpty()) {
            this.stopBlockingFuture.complete(null);
        }
        return this.stopBlockingFuture;
    }
}

