/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.pagememory.FullPageId;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.configuration.PersistentDataRegionConfiguration;
import org.apache.ignite3.internal.pagememory.configuration.ReplacementMode;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.pagememory.mem.DirectMemoryProvider;
import org.apache.ignite3.internal.pagememory.mem.DirectMemoryRegion;
import org.apache.ignite3.internal.pagememory.mem.IgniteOutOfMemoryException;
import org.apache.ignite3.internal.pagememory.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite3.internal.pagememory.persistence.CheckpointUrgency;
import org.apache.ignite3.internal.pagememory.persistence.DirtyFullPageId;
import org.apache.ignite3.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite3.internal.pagememory.persistence.LoadedPagesMap;
import org.apache.ignite3.internal.pagememory.persistence.PageHeader;
import org.apache.ignite3.internal.pagememory.persistence.PagePayloadSizeAware;
import org.apache.ignite3.internal.pagememory.persistence.PagePool;
import org.apache.ignite3.internal.pagememory.persistence.PageReadWriteManager;
import org.apache.ignite3.internal.pagememory.persistence.PageStoreWriter;
import org.apache.ignite3.internal.pagememory.persistence.PartitionDestructionLockManager;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemoryMetricSource;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemoryMetrics;
import org.apache.ignite3.internal.pagememory.persistence.RobinHoodBackwardShiftHashMap;
import org.apache.ignite3.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointPages;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite3.internal.pagememory.persistence.replacement.ClockPageReplacementPolicyFactory;
import org.apache.ignite3.internal.pagememory.persistence.replacement.DelayedDirtyPageWrite;
import org.apache.ignite3.internal.pagememory.persistence.replacement.DelayedPageReplacementTracker;
import org.apache.ignite3.internal.pagememory.persistence.replacement.PageReplacementPolicy;
import org.apache.ignite3.internal.pagememory.persistence.replacement.PageReplacementPolicyFactory;
import org.apache.ignite3.internal.pagememory.persistence.replacement.RandomLruPageReplacementPolicyFactory;
import org.apache.ignite3.internal.pagememory.persistence.replacement.SegmentedLruPageReplacementPolicyFactory;
import org.apache.ignite3.internal.pagememory.persistence.throttling.PagesWriteThrottlePolicy;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.FastTimestamps;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.OffheapReadWriteLock;
import org.apache.ignite3.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PersistentPageMemory
implements PageMemory {
    private static final IgniteLogger LOG = Loggers.forClass(PersistentPageMemory.class);
    public static final long RELATIVE_PTR_MASK = 0xFFFFFFFFFFFFFFL;
    public static final long INVALID_REL_PTR = 0xFFFFFFFFFFFFFFL;
    public static final long OUTDATED_REL_PTR = 0x100000000000000L;
    public static final int TRY_AGAIN_TAG = -1;
    private final PersistentDataRegionConfiguration dataRegionConfiguration;
    private final PageIoRegistry ioRegistry;
    private final PageReadWriteManager pageStoreManager;
    private final int sysPageSize;
    private final PageReplacementPolicyFactory pageReplacementPolicyFactory;
    private final DirectMemoryProvider directMemoryProvider;
    private volatile Segment @Nullable [] segments;
    private final Object segmentsLock = new Object();
    private final OffheapReadWriteLock rwLock;
    private static final AtomicIntegerFieldUpdater<PersistentPageMemory> pageReplacementWarnedFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(PersistentPageMemory.class, "pageReplacementWarned");
    private volatile int pageReplacementWarned;
    private final long[] sizes;
    private volatile boolean started;
    private final AtomicReference<CheckpointUrgency> checkpointUrgency = new AtomicReference<CheckpointUrgency>(CheckpointUrgency.NOT_REQUIRED);
    @Nullable
    private volatile PagePool checkpointPool;
    @Nullable
    private volatile PagesWriteThrottlePolicy writeThrottle;
    private final DelayedPageReplacementTracker delayedPageReplacementTracker;
    private final CheckpointTimeoutLock checkpointTimeoutLock;
    private final PagePayloadSizeAware pagePayloadSizeProvider;
    private final PersistentPageMemoryMetrics metrics;

    public PersistentPageMemory(PersistentDataRegionConfiguration dataRegionConfiguration, PersistentPageMemoryMetricSource metricSource, PageIoRegistry ioRegistry, long[] segmentSizes, long checkpointBufferSize, PageReadWriteManager pageStoreManager, WriteDirtyPage flushDirtyPageForReplacement, CheckpointTimeoutLock checkpointTimeoutLock, OffheapReadWriteLock rwLock, PartitionDestructionLockManager partitionDestructionLockManager) {
        this(dataRegionConfiguration, metricSource, ioRegistry, segmentSizes, checkpointBufferSize, pageStoreManager, flushDirtyPageForReplacement, checkpointTimeoutLock, (tableId, tablePageSize) -> tablePageSize, rwLock, partitionDestructionLockManager);
    }

    public PersistentPageMemory(PersistentDataRegionConfiguration dataRegionConfiguration, PersistentPageMemoryMetricSource metricSource, PageIoRegistry ioRegistry, long[] segmentSizes, long checkpointBufferSize, PageReadWriteManager pageStoreManager, WriteDirtyPage flushDirtyPageForReplacement, CheckpointTimeoutLock checkpointTimeoutLock, PagePayloadSizeAware pagePayloadSizeProvider, OffheapReadWriteLock rwLock, PartitionDestructionLockManager partitionDestructionLockManager) {
        this.dataRegionConfiguration = dataRegionConfiguration;
        this.ioRegistry = ioRegistry;
        this.sizes = ArrayUtils.concat(segmentSizes, checkpointBufferSize);
        this.pageStoreManager = pageStoreManager;
        this.checkpointTimeoutLock = checkpointTimeoutLock;
        this.pagePayloadSizeProvider = pagePayloadSizeProvider;
        this.directMemoryProvider = new UnsafeMemoryProvider(null);
        int pageSize = dataRegionConfiguration.pageSize();
        this.sysPageSize = pageSize + 48;
        this.rwLock = rwLock;
        ReplacementMode replacementMode = this.dataRegionConfiguration.replacementMode();
        switch (replacementMode) {
            case RANDOM_LRU: {
                this.pageReplacementPolicyFactory = new RandomLruPageReplacementPolicyFactory();
                break;
            }
            case SEGMENTED_LRU: {
                this.pageReplacementPolicyFactory = new SegmentedLruPageReplacementPolicyFactory();
                break;
            }
            case CLOCK: {
                this.pageReplacementPolicyFactory = new ClockPageReplacementPolicyFactory();
                break;
            }
            default: {
                throw new IgniteInternalException("Unexpected page replacement mode: " + replacementMode);
            }
        }
        this.metrics = new PersistentPageMemoryMetrics(metricSource, this, dataRegionConfiguration);
        this.delayedPageReplacementTracker = new DelayedPageReplacementTracker(pageSize, (pageMemory, fullPageId, buffer) -> {
            this.metrics.incrementWriteToDiskMetric();
            flushDirtyPageForReplacement.write(pageMemory, fullPageId, buffer);
        }, LOG, this.sizes.length - 1, partitionDestructionLockManager);
        this.writeThrottle = null;
    }

    public void initThrottling(PagesWriteThrottlePolicy writeThrottle) {
        this.writeThrottle = writeThrottle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IgniteInternalException {
        Object object = this.segmentsLock;
        synchronized (object) {
            DirectMemoryRegion reg;
            if (this.started) {
                return;
            }
            this.started = true;
            this.directMemoryProvider.initialize(this.sizes);
            ArrayList<DirectMemoryRegion> regions = new ArrayList<DirectMemoryRegion>(this.sizes.length);
            while ((reg = this.directMemoryProvider.nextRegion()) != null) {
                regions.add(reg);
            }
            int regs = regions.size();
            Segment[] segments = new Segment[regs - 1];
            DirectMemoryRegion checkpointRegion = (DirectMemoryRegion)regions.get(regs - 1);
            this.checkpointPool = new PagePool(regs - 1, checkpointRegion, this.sysPageSize, this.rwLock);
            long checkpointBufferSize = checkpointRegion.size();
            long totalAllocated = 0L;
            int pages = 0;
            long totalTblSize = 0L;
            long totalReplSize = 0L;
            for (int i = 0; i < regs - 1; ++i) {
                assert (i < segments.length);
                DirectMemoryRegion reg2 = (DirectMemoryRegion)regions.get(i);
                totalAllocated += reg2.size();
                segments[i] = new Segment(i, (DirectMemoryRegion)regions.get(i));
                pages += segments[i].pages();
                totalTblSize += segments[i].tableSize();
                totalReplSize += segments[i].replacementSize();
            }
            this.segments = segments;
            if (LOG.isInfoEnabled()) {
                LOG.info("Started page memory [name='{}', memoryAllocated={}, pages={}, tableSize={}, replacementSize={}, checkpointBuffer={}]", this.dataRegionConfiguration.name(), IgniteUtils.readableSize(totalAllocated, false), pages, IgniteUtils.readableSize(totalTblSize, false), IgniteUtils.readableSize(totalReplSize, false), IgniteUtils.readableSize(checkpointBufferSize, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean deallocate) throws IgniteInternalException {
        Object object = this.segmentsLock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            LOG.debug("Stopping page memory", new Object[0]);
            Segment[] segments = this.segments;
            if (segments != null) {
                for (Segment seg : segments) {
                    seg.close();
                }
            }
            this.started = false;
            this.directMemoryProvider.shutdown(deallocate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePage(int grpId, long pageId, long page) {
        assert (this.started);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            seg.releasePage(page);
        }
        finally {
            seg.readLock().unlock();
        }
    }

    @Override
    public long readLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.readLock(page, pageId, false);
    }

    public long readLock(long absPtr, long pageId, boolean force, boolean touch) {
        assert (this.started);
        int tag = force ? -1 : PageIdUtils.tag(pageId);
        boolean locked = this.rwLock.readLock(absPtr + 32L, tag);
        if (!locked) {
            return 0L;
        }
        if (touch) {
            PageHeader.timestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
        }
        assert (PageIo.getCrc(absPtr + 48L) == 0);
        return absPtr + 48L;
    }

    private long readLock(long absPtr, long pageId, boolean force) {
        return this.readLock(absPtr, pageId, force, true);
    }

    @Override
    public void readUnlock(int grpId, long pageId, long page) {
        assert (this.started);
        this.readUnlockPage(page);
    }

    @Override
    public long writeLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.writeLock(grpId, pageId, page, false);
    }

    public long writeLock(int grpId, long pageId, long page, boolean restore) {
        assert (this.started);
        return this.writeLockPage(page, new FullPageId(pageId, grpId), !restore);
    }

    @Override
    public long tryWriteLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.tryWriteLockPage(page, new FullPageId(pageId, grpId), true);
    }

    @Override
    public void writeUnlock(int grpId, long pageId, long page, boolean dirtyFlag) {
        assert (this.started);
        this.writeUnlock(grpId, pageId, page, dirtyFlag, false);
    }

    public void writeUnlock(int grpId, long pageId, long page, boolean dirtyFlag, boolean restore) {
        assert (this.started);
        this.writeUnlockPage(page, new FullPageId(pageId, grpId), dirtyFlag, restore);
    }

    @Override
    public boolean isDirty(int grpId, long pageId, long page) {
        assert (this.started);
        return this.isDirty(page);
    }

    boolean isDirty(long absPtr) {
        return PageHeader.dirty(absPtr);
    }

    @Override
    public long allocatePageNoReuse(int grpId, int partId, byte flags) throws IgniteInternalCheckedException {
        assert (partId >= 0 && partId <= 65500) : "grpId=" + grpId + ", partId=" + partId;
        assert (this.started) : "grpId=" + grpId + ", partId=" + partId;
        assert (this.checkpointTimeoutLock.checkpointLockIsHeldByThread()) : "grpId=" + grpId + ", partId=" + partId;
        PagesWriteThrottlePolicy writeThrottle = this.writeThrottle;
        if (writeThrottle != null) {
            writeThrottle.onMarkDirty(false);
        }
        long pageId = this.pageStoreManager.allocatePage(grpId, partId, flags);
        Segment seg = this.segment(grpId, pageId);
        seg.writeLock().lock();
        try {
            FullPageId fullId = new FullPageId(pageId, grpId);
            int partGen = this.partGeneration(seg, fullId);
            long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), partGen, 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
            if (relPtr == 0x100000000000000L) {
                relPtr = seg.refreshOutdatedPage(grpId, pageId, false);
                seg.pageReplacementPolicy.onRemove(relPtr);
            }
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.borrowOrAllocateFreePage(pageId);
            }
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.removePageForReplacement();
            }
            long absPtr = seg.absolute(relPtr);
            GridUnsafe.zeroMemory(absPtr + 48L, this.pageSize());
            PageHeader.fullPageId(absPtr, fullId);
            PageHeader.timestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
            PageHeader.partitionGeneration(absPtr, partGen);
            this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
            PageHeader.headerIsValid(absPtr, true);
            assert (PageIo.getCrc(absPtr + 48L) == 0) : fullId;
            assert (!PageHeader.isAcquired(absPtr)) : String.format("Pin counter must be 0 for a new page [relPtr=%s, absPtr=%s, pinCntr=%s, fullId=%s]", StringUtils.hexLong(relPtr), StringUtils.hexLong(absPtr), PageHeader.pinCount(absPtr), fullId);
            this.setDirty(fullId, absPtr, true, true);
            seg.pageReplacementPolicy.onMiss(relPtr);
            seg.loadedPages.put(grpId, PageIdUtils.effectivePageId(pageId), relPtr, partGen);
        }
        catch (IgniteOutOfMemoryException oom) {
            IgniteOutOfMemoryException e = new IgniteOutOfMemoryException("Out of memory in data region [name=" + this.dataRegionConfiguration.name() + ", size=" + IgniteUtils.readableSize(this.dataRegionConfiguration.sizeBytes(), false) + ", persistence=true] Try the following:" + System.lineSeparator() + "  ^-- Increase maximum off-heap memory size" + System.lineSeparator() + "  ^-- Enable eviction or expiration policies");
            e.initCause(oom);
            throw e;
        }
        finally {
            seg.writeLock().unlock();
            this.delayedPageReplacementTracker.delayedPageWrite().flushCopiedPageIfExists();
        }
        return pageId;
    }

    @Override
    public ByteBuffer pageBuffer(long pageAddr) {
        return GridUnsafe.wrapPointer(pageAddr, this.pageSize());
    }

    @Override
    public boolean freePage(int grpId, long pageId) {
        assert (false) : "Free page should be never called directly when persistence is enabled.";
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long acquirePage(int grpId, long pageId) throws IgniteInternalCheckedException {
        long l;
        boolean readPageFromStore;
        long lockedPageAbsPtr;
        FullPageId fullId;
        block31: {
            assert (this.started) : "grpId=" + grpId + ", pageId=" + StringUtils.hexLong(pageId);
            assert (PageIdUtils.pageIndex(pageId) != 0) : String.format("Partition meta should should not be read through PageMemory so as not to occupy memory: [grpId=%s, pageId=%s]", grpId, StringUtils.hexLong(pageId));
            fullId = new FullPageId(pageId, grpId);
            Segment seg = this.segment(grpId, pageId);
            seg.readLock().lock();
            boolean waitUntilPageIsFullyInitialized = false;
            long resPointer = -1L;
            try {
                long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), this.partGeneration(seg, fullId), 0xFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL);
                if (relPtr != 0xFFFFFFFFFFFFFFL) {
                    long absPtr = seg.absolute(relPtr);
                    seg.acquirePage(absPtr);
                    seg.pageReplacementPolicy.onHit(relPtr);
                    resPointer = absPtr;
                    waitUntilPageIsFullyInitialized = true;
                    long l2 = absPtr;
                    return l2;
                }
            }
            finally {
                seg.readLock().unlock();
                if (waitUntilPageIsFullyInitialized) {
                    this.waitUntilPageIsFullyInitialized(resPointer);
                }
            }
            seg.writeLock().lock();
            lockedPageAbsPtr = -1L;
            readPageFromStore = false;
            try {
                long absPtr;
                int partGen = this.partGeneration(seg, fullId);
                long relPtr = seg.loadedPages.get(grpId, fullId.effectivePageId(), partGen, 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
                if (relPtr == 0xFFFFFFFFFFFFFFL) {
                    relPtr = seg.borrowOrAllocateFreePage(pageId);
                    if (relPtr == 0xFFFFFFFFFFFFFFL) {
                        relPtr = seg.removePageForReplacement();
                    }
                    absPtr = seg.absolute(relPtr);
                    PageHeader.fullPageId(absPtr, fullId);
                    PageHeader.timestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
                    PageHeader.partitionGeneration(absPtr, partGen);
                    assert (!PageHeader.isAcquired(absPtr)) : String.format("Pin counter must be 0 for a new page [relPtr=%s, absPtr=%s, pinCntr=%s, fullId=%s]", StringUtils.hexLong(relPtr), StringUtils.hexLong(absPtr), PageHeader.pinCount(absPtr), fullId);
                    this.setDirty(fullId, absPtr, false, false);
                    seg.pageReplacementPolicy.onMiss(relPtr);
                    seg.loadedPages.put(grpId, fullId.effectivePageId(), relPtr, partGen);
                    this.delayedPageReplacementTracker.waitUnlock(fullId);
                    readPageFromStore = true;
                    PageHeader.headerIsValid(absPtr, false);
                    this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
                    boolean locked = this.rwLock.writeLock(absPtr + 32L, -1);
                    assert (locked) : "Page ID " + fullId + " expected to be locked";
                    lockedPageAbsPtr = absPtr;
                } else if (relPtr == 0x100000000000000L) {
                    assert (PageIdUtils.pageIndex(pageId) == 0) : fullId;
                    relPtr = seg.refreshOutdatedPage(grpId, pageId, false);
                    absPtr = seg.absolute(relPtr);
                    long pageAddr = absPtr + 48L;
                    GridUnsafe.zeroMemory(pageAddr, this.pageSize());
                    PageHeader.fullPageId(absPtr, fullId);
                    PageHeader.timestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
                    PageHeader.partitionGeneration(absPtr, partGen);
                    PageIo.setPageId(pageAddr, pageId);
                    assert (!PageHeader.isAcquired(absPtr)) : String.format("Pin counter must be 0 for a new page [relPtr=%s, absPtr=%s, pinCntr=%s, fullId=%s]", StringUtils.hexLong(relPtr), StringUtils.hexLong(absPtr), PageHeader.pinCount(absPtr), fullId);
                    this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
                    seg.pageReplacementPolicy.onRemove(relPtr);
                    seg.pageReplacementPolicy.onMiss(relPtr);
                } else {
                    absPtr = seg.absolute(relPtr);
                    seg.pageReplacementPolicy.onHit(relPtr);
                }
                seg.acquirePage(absPtr);
                if (!readPageFromStore) {
                    resPointer = absPtr;
                    waitUntilPageIsFullyInitialized = true;
                }
                l = absPtr;
                seg.writeLock().unlock();
                if (!waitUntilPageIsFullyInitialized) break block31;
                this.waitUntilPageIsFullyInitialized(resPointer);
            }
            catch (Throwable throwable) {
                seg.writeLock().unlock();
                if (waitUntilPageIsFullyInitialized) {
                    this.waitUntilPageIsFullyInitialized(resPointer);
                }
                this.delayedPageReplacementTracker.delayedPageWrite().flushCopiedPageIfExists();
                if (readPageFromStore) {
                    assert (lockedPageAbsPtr != -1L) : "Page is expected to have a valid address [pageId=" + fullId + ", lockedPageAbsPtr=" + StringUtils.hexLong(lockedPageAbsPtr) + "]";
                    assert (this.isPageWriteLocked(lockedPageAbsPtr)) : "Page is expected to be locked: [pageId=" + fullId + "]";
                    long pageAddr = lockedPageAbsPtr + 48L;
                    ByteBuffer buf = GridUnsafe.wrapPointer(pageAddr, this.pageSize());
                    long actualPageId = 0L;
                    try {
                        this.pageStoreManager.read(grpId, pageId, buf, false);
                        actualPageId = PageIo.getPageId(buf);
                        this.metrics.incrementReadFromDiskMetric();
                        this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                    }
                    catch (Throwable throwable2) {
                        this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                        PageHeader.headerIsValid(lockedPageAbsPtr, true);
                        throw throwable2;
                    }
                    PageHeader.headerIsValid(lockedPageAbsPtr, true);
                }
                throw throwable;
            }
        }
        this.delayedPageReplacementTracker.delayedPageWrite().flushCopiedPageIfExists();
        if (readPageFromStore) {
            assert (lockedPageAbsPtr != -1L) : "Page is expected to have a valid address [pageId=" + fullId + ", lockedPageAbsPtr=" + StringUtils.hexLong(lockedPageAbsPtr) + "]";
            assert (this.isPageWriteLocked(lockedPageAbsPtr)) : "Page is expected to be locked: [pageId=" + fullId + "]";
            long pageAddr = lockedPageAbsPtr + 48L;
            ByteBuffer buf = GridUnsafe.wrapPointer(pageAddr, this.pageSize());
            long actualPageId = 0L;
            try {
                this.pageStoreManager.read(grpId, pageId, buf, false);
                actualPageId = PageIo.getPageId(buf);
                this.metrics.incrementReadFromDiskMetric();
                this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
            }
            catch (Throwable throwable) {
                this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                PageHeader.headerIsValid(lockedPageAbsPtr, true);
                throw throwable;
            }
            PageHeader.headerIsValid(lockedPageAbsPtr, true);
        }
        return l;
    }

    private void waitUntilPageIsFullyInitialized(long absPtr) {
        if (!PageHeader.headerIsValid(absPtr)) {
            long lockAddr = absPtr + 32L;
            this.rwLock.readLock(lockAddr, -1);
            this.rwLock.readUnlock(lockAddr);
        }
    }

    @Override
    public int pageSize() {
        return this.sysPageSize - 48;
    }

    @Override
    public int systemPageSize() {
        return this.sysPageSize;
    }

    @Override
    public int realPageSize(int tableId) {
        return this.pagePayloadSizeProvider.pagePayloadSize(tableId, this.pageSize());
    }

    public long totalPages() {
        Segment[] segments = this.segments;
        if (segments == null) {
            return 0L;
        }
        long res = 0L;
        for (Segment segment : segments) {
            res += (long)segment.pages();
        }
        return res;
    }

    private void copyInBuffer(long absPtr, ByteBuffer tmpBuf) {
        if (tmpBuf.isDirect()) {
            long tmpPtr = GridUnsafe.bufferAddress(tmpBuf);
            GridUnsafe.copyMemory(absPtr + 48L, tmpPtr, this.pageSize());
            assert (PageIo.getCrc(absPtr + 48L) == 0);
            assert (PageIo.getCrc(tmpPtr) == 0);
        } else {
            byte[] arr = tmpBuf.array();
            assert (arr.length == this.pageSize());
            GridUnsafe.copyMemory(null, absPtr + 48L, arr, GridUnsafe.BYTE_ARR_OFF, this.pageSize());
        }
    }

    private int partGeneration(Segment seg, FullPageId fullPageId) {
        return seg.partGeneration(fullPageId.groupId(), fullPageId.partitionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int partGeneration(int grpId, int partId) {
        Segment seg = this.segment(grpId, partId);
        seg.readLock().lock();
        try {
            int n = seg.partGeneration(grpId, partId);
            return n;
        }
        finally {
            seg.readLock().unlock();
        }
    }

    private long resolveRelativePointer(Segment seg, FullPageId fullId, int reqVer) {
        return seg.loadedPages.get(fullId.groupId(), fullId.effectivePageId(), reqVer, 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invalidate(int grpId, int partId) {
        Object object = this.segmentsLock;
        synchronized (object) {
            if (!this.started) {
                return 0;
            }
            int resultPartitionGeneration = 0;
            for (Segment segment : this.segments) {
                segment.writeLock().lock();
                try {
                    int newPartitionGeneration = segment.incrementPartGeneration(grpId, partId);
                    if (resultPartitionGeneration == 0) {
                        resultPartitionGeneration = newPartitionGeneration;
                    }
                    if ($assertionsDisabled || resultPartitionGeneration == newPartitionGeneration) continue;
                    throw new AssertionError((Object)String.format("grpId=%s, partId=%s, resultPartitionGeneration=%s, newPartitionGeneration=%s", grpId, partId, resultPartitionGeneration, newPartitionGeneration));
                }
                finally {
                    segment.writeLock().unlock();
                }
            }
            return resultPartitionGeneration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGroupDestroyed(int grpId) {
        for (Segment seg : this.segments) {
            seg.writeLock().lock();
            try {
                seg.resetGroupPartitionsGeneration(grpId);
            }
            finally {
                seg.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long loadedPages() {
        long total = 0L;
        Segment[] segments = this.segments;
        if (segments != null) {
            for (Segment seg : segments) {
                if (seg == null) break;
                seg.readLock().lock();
                try {
                    if (seg.closed) continue;
                    total += (long)seg.loadedPages.size();
                }
                finally {
                    seg.readLock().unlock();
                }
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquiredPages() {
        Segment[] segments = this.segments;
        if (segments == null) {
            return 0L;
        }
        long total = 0L;
        for (Segment seg : segments) {
            seg.readLock().lock();
            try {
                if (seg.closed) continue;
                total += (long)seg.acquiredPages();
            }
            finally {
                seg.readLock().unlock();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLoadedPage(FullPageId fullPageId) {
        int grpId = fullPageId.groupId();
        long pageId = fullPageId.effectivePageId();
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            long res = seg.loadedPages.get(grpId, pageId, this.partGeneration(seg, fullPageId), 0xFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL);
            boolean bl = res != 0xFFFFFFFFFFFFFFL;
            return bl;
        }
        finally {
            seg.readLock().unlock();
        }
    }

    @Override
    public long readLockForce(int grpId, long pageId, long page) {
        assert (this.started);
        return this.readLock(page, pageId, true);
    }

    void readUnlockPage(long absPtr) {
        this.rwLock.readUnlock(absPtr + 32L);
    }

    public boolean hasTempCopy(long absPtr) {
        return PageHeader.tempBufferPointer(absPtr) != 0xFFFFFFFFFFFFFFL;
    }

    private long tryWriteLockPage(long absPtr, FullPageId fullId, boolean checkTag) {
        int tag = checkTag ? PageIdUtils.tag(fullId.pageId()) : -1;
        return !this.rwLock.tryWriteLock(absPtr + 32L, tag) ? 0L : this.postWriteLockPage(absPtr, fullId);
    }

    private long writeLockPage(long absPtr, FullPageId fullId, boolean checkTag) {
        int tag = checkTag ? PageIdUtils.tag(fullId.pageId()) : -1;
        boolean locked = this.rwLock.writeLock(absPtr + 32L, tag);
        return locked ? this.postWriteLockPage(absPtr, fullId) : 0L;
    }

    private long postWriteLockPage(long absPtr, FullPageId fullId) {
        PageHeader.timestamp(absPtr, FastTimestamps.coarseCurrentTimeMillis());
        DirtyFullPageId dirtyFullId = PageHeader.dirtyFullPageId(absPtr);
        if (this.isInCheckpoint(dirtyFullId) && PageHeader.tempBufferPointer(absPtr) == 0xFFFFFFFFFFFFFFL) {
            long tmpRelPtr;
            PagePool checkpointPool = this.checkpointPool;
            while ((tmpRelPtr = checkpointPool.borrowOrAllocateFreePage(PageIdUtils.tag(fullId.pageId()))) == 0xFFFFFFFFFFFFFFL) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            PageHeader.acquirePage(absPtr);
            long tmpAbsPtr = checkpointPool.absolute(tmpRelPtr);
            GridUnsafe.copyMemory(null, absPtr + 48L, null, tmpAbsPtr + 48L, this.pageSize());
            assert (PageIo.getType(tmpAbsPtr + 48L) != 0) : "Invalid state. Type is 0! pageId = " + StringUtils.hexLong(fullId.pageId());
            assert (PageIo.getVersion(tmpAbsPtr + 48L) != 0) : "Invalid state. Version is 0! pageId = " + StringUtils.hexLong(fullId.pageId());
            PageHeader.dirty(absPtr, false);
            PageHeader.tempBufferPointer(absPtr, tmpRelPtr);
            PageHeader.dirtyFullPageId(tmpAbsPtr, dirtyFullId);
            assert (PageIo.getCrc(absPtr + 48L) == 0);
            assert (PageIo.getCrc(tmpAbsPtr + 48L) == 0);
        }
        assert (PageIo.getCrc(absPtr + 48L) == 0);
        return absPtr + 48L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeUnlockPage(long page, FullPageId fullId, boolean markDirty, boolean restore) {
        boolean wasDirty;
        block13: {
            wasDirty = this.isDirty(page);
            try {
                assert (PageIo.getCrc(page + 48L) == 0);
                if (!markDirty) break block13;
                this.setDirty(fullId, page, true, false);
            }
            catch (Throwable throwable) {
                long pageId = PageIo.getPageId(page + 48L);
                try {
                    assert (pageId != 0L) : StringUtils.hexLong(PageHeader.pageId(page));
                    this.rwLock.writeUnlock(page + 32L, PageIdUtils.tag(pageId));
                    assert (PageIo.getVersion(page + 48L) != 0) : this.dumpPage(pageId, fullId.groupId());
                    assert (PageIo.getType(page + 48L) != 0) : StringUtils.hexLong(pageId);
                    PagesWriteThrottlePolicy writeThrottle = this.writeThrottle;
                    if (writeThrottle == null || restore || wasDirty || !markDirty) throw throwable;
                    writeThrottle.onMarkDirty(this.isInCheckpoint(PageHeader.dirtyFullPageId(page)));
                    throw throwable;
                }
                catch (AssertionError ex) {
                    LOG.debug("Failed to unlock page [fullPageId={}, binPage={}]", fullId, StringUtils.toHexString(page, this.systemPageSize()));
                    throw ex;
                }
            }
        }
        long pageId = PageIo.getPageId(page + 48L);
        try {
            assert (pageId != 0L) : StringUtils.hexLong(PageHeader.pageId(page));
            this.rwLock.writeUnlock(page + 32L, PageIdUtils.tag(pageId));
            assert (PageIo.getVersion(page + 48L) != 0) : this.dumpPage(pageId, fullId.groupId());
            assert (PageIo.getType(page + 48L) != 0) : StringUtils.hexLong(pageId);
            PagesWriteThrottlePolicy writeThrottle = this.writeThrottle;
            if (writeThrottle == null || restore || wasDirty || !markDirty) return;
            writeThrottle.onMarkDirty(this.isInCheckpoint(PageHeader.dirtyFullPageId(page)));
            return;
        }
        catch (AssertionError ex) {
            LOG.debug("Failed to unlock page [fullPageId={}, binPage={}]", fullId, StringUtils.toHexString(page, this.systemPageSize()));
            throw ex;
        }
    }

    private String dumpPage(long pageId, int grpId) {
        int pageIdx = PageIdUtils.pageIndex(pageId);
        int partId = PageIdUtils.partitionId(pageId);
        long off = (long)(pageIdx + 1) * (long)this.pageSize();
        return StringUtils.hexLong(pageId) + " (grpId=" + grpId + ", pageIdx=" + pageIdx + ", partId=" + partId + ", offH=" + Long.toHexString(off) + ")";
    }

    boolean isPageWriteLocked(long absPtr) {
        return this.rwLock.isWriteLocked(absPtr + 32L);
    }

    boolean isPageReadLocked(long absPtr) {
        return this.rwLock.isReadLocked(absPtr + 32L);
    }

    public int activePagesCount() {
        Segment[] segments = this.segments;
        if (segments == null) {
            return 0;
        }
        int total = 0;
        for (Segment seg : segments) {
            total += seg.acquiredPages();
        }
        return total;
    }

    private void setDirty(FullPageId pageId, long absPtr, boolean dirty, boolean forceAdd) {
        boolean wasDirty = PageHeader.dirty(absPtr, dirty);
        int partGen = PageHeader.partitionGeneration(absPtr);
        assert (partGen != -1) : pageId;
        if (dirty) {
            assert (this.checkpointTimeoutLock.checkpointLockIsHeldByThread()) : pageId;
            assert (PageIdUtils.pageIndex(pageId.pageId()) != 0) : "Partition meta should only be updated via the instance of PartitionMeta: " + pageId;
            if (!wasDirty || forceAdd) {
                CheckpointUrgency urgency;
                long dirtyPagesCnt;
                Segment seg = this.segment(pageId.groupId(), pageId.pageId());
                if (seg.dirtyPages.add(new DirtyFullPageId(pageId, partGen)) && (dirtyPagesCnt = seg.dirtyPagesCntr.incrementAndGet()) >= seg.dirtyPagesSoftThreshold && (urgency = this.checkpointUrgency.get()) != CheckpointUrgency.MUST_TRIGGER) {
                    if (dirtyPagesCnt >= seg.dirtyPagesHardThreshold) {
                        this.checkpointUrgency.set(CheckpointUrgency.MUST_TRIGGER);
                    } else if (urgency != CheckpointUrgency.SHOULD_TRIGGER) {
                        this.checkpointUrgency.compareAndSet(CheckpointUrgency.NOT_REQUIRED, CheckpointUrgency.SHOULD_TRIGGER);
                    }
                }
            }
        } else {
            Segment seg = this.segment(pageId.groupId(), pageId.pageId());
            if (seg.dirtyPages.remove(new DirtyFullPageId(pageId, partGen))) {
                seg.dirtyPagesCntr.decrementAndGet();
            }
        }
    }

    private Segment segment(int grpId, long pageId) {
        int idx = PersistentPageMemory.segmentIndex(grpId, pageId, this.segments.length);
        return this.segments[idx];
    }

    public static int segmentIndex(int grpId, long pageId, int segments) {
        pageId = PageIdUtils.effectivePageId(pageId);
        int hash = IgniteUtils.hash(pageId * 65537L + (long)grpId);
        return IgniteUtils.safeAbs(hash) % segments;
    }

    @TestOnly
    public Set<DirtyFullPageId> dirtyPages() {
        Segment[] segments = this.segments;
        if (segments == null) {
            return Set.of();
        }
        HashSet<DirtyFullPageId> res = new HashSet<DirtyFullPageId>();
        for (Segment seg : segments) {
            res.addAll(seg.dirtyPages);
        }
        return res;
    }

    public double dirtyPagesRatio() {
        Segment[] segments = this.segments;
        if (segments == null) {
            return 0.0;
        }
        long res = 0L;
        for (Segment segment : segments) {
            res = Math.max(res, segment.dirtyPagesRatio());
        }
        return (double)res * 1.0E-4;
    }

    @Override
    public PageIoRegistry ioRegistry() {
        return this.ioRegistry;
    }

    public CheckpointUrgency checkpointUrgency() {
        return this.checkpointUrgency.get();
    }

    public boolean shouldThrottle(double dirtyRatioThreshold) {
        Segment[] segments = this.segments;
        if (segments == null) {
            return false;
        }
        for (Segment segment : segments) {
            if (!segment.shouldThrottle(dirtyRatioThreshold)) continue;
            return true;
        }
        return false;
    }

    public int usedCheckpointBufferPages() {
        PagePool checkpointPool = this.checkpointPool;
        return checkpointPool == null ? 0 : checkpointPool.size();
    }

    public int maxCheckpointBufferPages() {
        PagePool checkpointPool = this.checkpointPool;
        return checkpointPool == null ? 0 : checkpointPool.pages();
    }

    private void releaseCheckpointBufferPage(long tmpBufPtr) {
        PagePool checkpointPool = this.checkpointPool;
        assert (checkpointPool != null);
        int resultCounter = checkpointPool.releaseFreePage(tmpBufPtr);
        PagesWriteThrottlePolicy writeThrottle = this.writeThrottle;
        if (writeThrottle != null && resultCounter == checkpointPool.pages() / 2) {
            writeThrottle.wakeupThrottledThreads();
        }
    }

    private boolean isInCheckpoint(DirtyFullPageId pageId) {
        Segment seg = this.segment(pageId.groupId(), pageId.pageId());
        CheckpointPages pages0 = seg.checkpointPages;
        return pages0 != null && pages0.contains(pageId);
    }

    private boolean removeOnCheckpoint(DirtyFullPageId fullPageId) {
        Segment seg = this.segment(fullPageId.groupId(), fullPageId.pageId());
        CheckpointPages pages0 = seg.checkpointPages;
        assert (pages0 != null) : fullPageId;
        return pages0.removeOnCheckpoint(fullPageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPageForCheckpoint(long absPtr, DirtyFullPageId fullId, ByteBuffer buf, int partitionGeneration, boolean pageSingleAcquire, PageStoreWriter pageStoreWriter, CheckpointMetricsTracker tracker, boolean useTryWriteLockOnPage) throws IgniteInternalCheckedException {
        assert (absPtr != 0L) : fullId.pageId();
        assert (PageHeader.isAcquired(absPtr) || !this.isInCheckpoint(fullId)) : fullId.pageId();
        if (useTryWriteLockOnPage) {
            if (!this.rwLock.tryWriteLock(absPtr + 32L, -1)) {
                if (!pageSingleAcquire) {
                    PageHeader.releasePage(absPtr);
                }
                buf.clear();
                if (this.isInCheckpoint(fullId)) {
                    pageStoreWriter.writePage(fullId, buf, -1);
                }
                return;
            }
        } else {
            boolean locked = this.rwLock.writeLock(absPtr + 32L, -1);
            assert (locked) : StringUtils.hexLong(fullId.pageId());
        }
        if (!this.removeOnCheckpoint(fullId)) {
            this.rwLock.writeUnlock(absPtr + 32L, -1);
            if (!pageSingleAcquire) {
                PageHeader.releasePage(absPtr);
            }
            return;
        }
        boolean canWrite = false;
        try {
            long tmpRelPtr = PageHeader.tempBufferPointer(absPtr);
            if (tmpRelPtr != 0xFFFFFFFFFFFFFFL) {
                PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
                long tmpAbsPtr = this.checkpointPool.absolute(tmpRelPtr);
                this.copyInBuffer(tmpAbsPtr, buf);
                PageHeader.dirtyFullPageId(tmpAbsPtr, DirtyFullPageId.NULL_PAGE);
                GridUnsafe.zeroMemory(tmpAbsPtr + 48L, this.pageSize());
                tracker.onCopyOnWritePageWritten();
                this.releaseCheckpointBufferPage(tmpRelPtr);
                if (!pageSingleAcquire) {
                    PageHeader.releasePage(absPtr);
                }
            } else {
                this.copyInBuffer(absPtr, buf);
                PageHeader.dirty(absPtr, false);
            }
            assert (PageIo.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + StringUtils.hexLong(fullId.pageId());
            assert (PageIo.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + StringUtils.hexLong(fullId.pageId());
            canWrite = true;
        }
        finally {
            this.rwLock.writeUnlock(absPtr + 32L, -1);
            if (canWrite) {
                buf.rewind();
                pageStoreWriter.writePage(fullId, buf, partitionGeneration);
                buf.rewind();
                this.metrics.incrementWriteToDiskMetric();
            }
            PageHeader.releasePage(absPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointWritePage(DirtyFullPageId fullId, ByteBuffer buf, PageStoreWriter pageStoreWriter, CheckpointMetricsTracker tracker, boolean useTryWriteLockOnPage) throws IgniteInternalCheckedException {
        long relPtr;
        int partGen;
        assert (buf.remaining() == this.pageSize()) : "fullId=" + fullId + ", remaining=" + buf.remaining();
        Segment seg = this.segment(fullId.groupId(), fullId.pageId());
        long absPtr = 0L;
        boolean pageSingleAcquire = false;
        seg.readLock().lock();
        try {
            if (!this.isInCheckpoint(fullId)) {
                return;
            }
            partGen = this.partGeneration(seg, fullId);
            relPtr = this.resolveRelativePointer(seg, fullId, partGen);
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                return;
            }
            if (relPtr != 0x100000000000000L) {
                absPtr = seg.absolute(relPtr);
                if (fullId.partitionGeneration() != PageHeader.partitionGeneration(absPtr)) {
                    return;
                }
                if (PageHeader.tempBufferPointer(absPtr) == 0xFFFFFFFFFFFFFFL) {
                    PageHeader.acquirePage(absPtr);
                } else {
                    pageSingleAcquire = true;
                }
            }
        }
        finally {
            seg.readLock().unlock();
        }
        if (relPtr == 0x100000000000000L) {
            seg.writeLock().lock();
            try {
                relPtr = this.resolveRelativePointer(seg, fullId, this.partGeneration(seg, fullId));
                if (relPtr == 0xFFFFFFFFFFFFFFL) {
                    return;
                }
                if (relPtr == 0x100000000000000L) {
                    relPtr = seg.refreshOutdatedPage(fullId.groupId(), fullId.effectivePageId(), true);
                    seg.pageReplacementPolicy.onRemove(relPtr);
                    seg.pool.releaseFreePage(relPtr);
                }
                return;
            }
            finally {
                seg.writeLock().unlock();
            }
        }
        this.copyPageForCheckpoint(absPtr, fullId, buf, partGen, pageSingleAcquire, pageStoreWriter, tracker, useTryWriteLockOnPage);
    }

    public DirtyFullPageId pullPageFromCpBuffer() {
        long idx = GridUnsafe.getLong(this.checkpointPool.lastAllocatedIdxPtr);
        long lastIdx = ThreadLocalRandom.current().nextLong(idx / 2L, idx);
        while (--lastIdx > 1L) {
            assert ((lastIdx & 0xFFFFFF0000000000L) == 0L);
            long relative = this.checkpointPool.relative(lastIdx);
            long freePageAbsPtr = this.checkpointPool.absolute(relative);
            DirtyFullPageId fullPageId = PageHeader.dirtyFullPageId(freePageAbsPtr);
            if (fullPageId.pageId() == DirtyFullPageId.NULL_PAGE.pageId() || fullPageId.groupId() == DirtyFullPageId.NULL_PAGE.groupId() || !this.isInCheckpoint(fullPageId)) continue;
            return fullPageId;
        }
        return DirtyFullPageId.NULL_PAGE;
    }

    public Collection<DirtyFullPageId> beginCheckpoint(CheckpointProgress checkpointProgress) throws IgniteInternalException {
        if (this.segments == null) {
            return List.of();
        }
        Set[] dirtyPageIds = new Set[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            Set<DirtyFullPageId> segmentDirtyPages;
            Segment segment = this.segments[i];
            assert (segment.checkpointPages == null) : String.format("Failed to begin checkpoint (it is already in progress): [region=%s, segmentIdx=%s]", this.dataRegionConfiguration.name(), i);
            dirtyPageIds[i] = segmentDirtyPages = segment.dirtyPages;
            segment.checkpointPages = new CheckpointPages(segmentDirtyPages, checkpointProgress);
            segment.resetDirtyPages();
        }
        this.checkpointUrgency.set(CheckpointUrgency.NOT_REQUIRED);
        PagesWriteThrottlePolicy writeThrottle = this.writeThrottle;
        if (writeThrottle != null) {
            writeThrottle.onBeginCheckpoint();
        }
        return CollectionUtils.concat(dirtyPageIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCheckpoint() {
        Segment[] segments = this.segments;
        if (segments == null) {
            return;
        }
        Object object = this.segmentsLock;
        synchronized (object) {
            for (Segment seg : segments) {
                seg.checkpointPages = null;
            }
        }
        PagesWriteThrottlePolicy writeThrottle = this.writeThrottle;
        if (writeThrottle != null) {
            writeThrottle.onFinishCheckpoint();
        }
    }

    public boolean isCpBufferOverflowThresholdExceeded() {
        PagesWriteThrottlePolicy writeThrottle = this.writeThrottle;
        if (writeThrottle != null) {
            return writeThrottle.isCpBufferOverflowThresholdExceeded();
        }
        assert (this.started);
        PagePool checkpointPool = this.checkpointPool;
        int checkpointBufLimit = (int)((float)checkpointPool.pages() * 0.6666667f);
        return checkpointPool.size() > checkpointBufLimit;
    }

    @TestOnly
    public boolean pageReplacementOccurred() {
        return this.pageReplacementWarned > 0;
    }

    public class Segment
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 0L;
        private static final int ACQUIRED_PAGES_SIZEOF = 4;
        private static final int ACQUIRED_PAGES_PADDING = 4;
        private final LoadedPagesMap loadedPages;
        private final long acquiredPagesPtr;
        private final PagePool pool;
        private final PageReplacementPolicy pageReplacementPolicy;
        private final long memPerTbl;
        private long memPerRepl;
        private volatile Set<DirtyFullPageId> dirtyPages = ConcurrentHashMap.newKeySet();
        private final AtomicLong dirtyPagesCntr = new AtomicLong();
        @Nullable
        private volatile CheckpointPages checkpointPages;
        private final long dirtyPagesSoftThreshold;
        private final long dirtyPagesHardThreshold;
        private static final int INIT_PART_GENERATION = 1;
        private final Object2IntMap<GroupPartitionId> partGenerationMap = new Object2IntOpenHashMap();
        private boolean closed;

        private Segment(int idx, DirectMemoryRegion region) {
            long totalMemory = region.size();
            int pages = (int)(totalMemory / (long)PersistentPageMemory.this.sysPageSize);
            this.acquiredPagesPtr = region.address();
            GridUnsafe.putIntVolatile(null, this.acquiredPagesPtr, 0);
            int ldPagesMapOffInRegion = 8;
            long ldPagesAddr = region.address() + (long)ldPagesMapOffInRegion;
            this.memPerTbl = RobinHoodBackwardShiftHashMap.requiredMemory(pages);
            this.loadedPages = new RobinHoodBackwardShiftHashMap(ldPagesAddr, this.memPerTbl);
            pages = (int)((totalMemory - this.memPerTbl - (long)ldPagesMapOffInRegion) / (long)PersistentPageMemory.this.sysPageSize);
            this.memPerRepl = PersistentPageMemory.this.pageReplacementPolicyFactory.requiredMemory(pages);
            DirectMemoryRegion poolRegion = region.slice(this.memPerTbl + this.memPerRepl + (long)ldPagesMapOffInRegion);
            this.pool = new PagePool(idx, poolRegion, PersistentPageMemory.this.sysPageSize, PersistentPageMemory.this.rwLock);
            this.pageReplacementPolicy = PersistentPageMemory.this.pageReplacementPolicyFactory.create(this, region.address() + this.memPerTbl + (long)ldPagesMapOffInRegion, this.pool.pages());
            this.dirtyPagesSoftThreshold = (long)this.pool.pages() * 3L / 4L;
            this.dirtyPagesHardThreshold = (long)this.pool.pages() * 9L / 10L;
        }

        private void close() {
            this.writeLock().lock();
            try {
                this.closed = true;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        private long dirtyPagesRatio() {
            return this.dirtyPagesCntr.longValue() * 10000L / (long)this.pages();
        }

        private int pages() {
            return this.pool.pages();
        }

        private long tableSize() {
            return this.memPerTbl;
        }

        private long replacementSize() {
            return this.memPerRepl;
        }

        private void acquirePage(long absPtr) {
            PageHeader.acquirePage(absPtr);
            GridUnsafe.incrementAndGetInt(this.acquiredPagesPtr);
        }

        private void releasePage(long absPtr) {
            PageHeader.releasePage(absPtr);
            GridUnsafe.decrementAndGetInt(this.acquiredPagesPtr);
        }

        private int acquiredPages() {
            return GridUnsafe.getInt(this.acquiredPagesPtr);
        }

        private long borrowOrAllocateFreePage(long pageId) {
            return this.pool.borrowOrAllocateFreePage(PageIdUtils.tag(pageId));
        }

        private void resetDirtyPages() {
            this.dirtyPages = ConcurrentHashMap.newKeySet();
            this.dirtyPagesCntr.set(0L);
        }

        public boolean tryToRemovePage(FullPageId fullPageId, long absPtr) throws IgniteInternalCheckedException {
            assert (this.writeLock().isHeldByCurrentThread()) : fullPageId;
            if (PageHeader.isAcquired(absPtr)) {
                return false;
            }
            if (PersistentPageMemory.this.isDirty(absPtr)) {
                DirtyFullPageId dirtyFullPageId = PageHeader.dirtyFullPageId(absPtr);
                CheckpointPages checkpointPages = this.checkpointPages;
                if (checkpointPages != null && checkpointPages.removeOnPageReplacement(dirtyFullPageId)) {
                    checkpointPages.blockFsyncOnPageReplacement(dirtyFullPageId);
                    DelayedDirtyPageWrite delayedDirtyPageWrite = PersistentPageMemory.this.delayedPageReplacementTracker.delayedPageWrite();
                    delayedDirtyPageWrite.copyPageToTemporaryBuffer(PersistentPageMemory.this, dirtyFullPageId, GridUnsafe.wrapPointer(absPtr + 48L, PersistentPageMemory.this.pageSize()), checkpointPages);
                    PersistentPageMemory.this.setDirty(fullPageId, absPtr, false, true);
                    this.loadedPages.remove(fullPageId.groupId(), fullPageId.effectivePageId());
                    return true;
                }
                return false;
            }
            this.loadedPages.remove(fullPageId.groupId(), fullPageId.effectivePageId());
            return true;
        }

        public long refreshOutdatedPage(int grpId, long pageId, boolean rmv) {
            assert (this.writeLock().isHeldByCurrentThread()) : "grpId=" + grpId + ", pageId=" + pageId;
            int partGen = this.partGeneration(grpId, PageIdUtils.partitionId(pageId));
            long relPtr = this.loadedPages.refresh(grpId, PageIdUtils.effectivePageId(pageId), partGen);
            long absPtr = this.absolute(relPtr);
            GridUnsafe.zeroMemory(absPtr + 48L, PersistentPageMemory.this.pageSize());
            PageHeader.dirty(absPtr, false);
            long tmpBufPtr = PageHeader.tempBufferPointer(absPtr);
            if (tmpBufPtr != 0xFFFFFFFFFFFFFFL) {
                GridUnsafe.zeroMemory(PersistentPageMemory.this.checkpointPool.absolute(tmpBufPtr) + 48L, PersistentPageMemory.this.pageSize());
                PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
                PageHeader.releasePage(absPtr);
                PersistentPageMemory.this.releaseCheckpointBufferPage(tmpBufPtr);
            }
            if (rmv) {
                this.loadedPages.remove(grpId, PageIdUtils.effectivePageId(pageId));
            }
            return relPtr;
        }

        private long removePageForReplacement() throws IgniteInternalCheckedException {
            assert (this.getWriteHoldCount() > 0);
            if (PersistentPageMemory.this.pageReplacementWarned == 0 && pageReplacementWarnedFieldUpdater.compareAndSet(PersistentPageMemory.this, 0, 1)) {
                LOG.warn("Page replacements started, pages will be rotated with disk, this will affect storage performance (consider increasing PageMemoryDataRegionConfiguration#setMaxSize for data region) [region={}]", PersistentPageMemory.this.dataRegionConfiguration.name());
            }
            if (this.acquiredPages() >= this.loadedPages.size()) {
                throw this.oomException("all pages are acquired");
            }
            return this.pageReplacementPolicy.replace();
        }

        public IgniteOutOfMemoryException oomException(String reason) {
            return new IgniteOutOfMemoryException("Failed to find a page for eviction (" + reason + ") [segmentCapacity=" + this.loadedPages.capacity() + ", loaded=" + this.loadedPages.size() + ", dirtyPagesSoftThreshold=" + this.dirtyPagesSoftThreshold + ", dirtyPagesHardThreshold=" + this.dirtyPagesHardThreshold + ", dirtyPages=" + this.dirtyPagesCntr + ", pinned=" + this.acquiredPages() + "]" + System.lineSeparator() + "Out of memory in data region [name=" + PersistentPageMemory.this.dataRegionConfiguration.name() + ", size=" + IgniteUtils.readableSize(PersistentPageMemory.this.dataRegionConfiguration.sizeBytes(), false) + ", persistence=true] Try the following:" + System.lineSeparator() + "  ^-- Increase off-heap memory size" + System.lineSeparator());
        }

        public long absolute(long relPtr) {
            return this.pool.absolute(relPtr);
        }

        public long relative(long pageIdx) {
            return this.pool.relative(pageIdx);
        }

        public long pageIndex(long relPtr) {
            return this.pool.pageIndex(relPtr);
        }

        public int partGeneration(int grpId, int partId) {
            assert (this.getReadHoldCount() > 0 || this.getWriteHoldCount() > 0) : "grpId=" + grpId + ", partId=" + partId;
            GroupPartitionId groupPartitionId = new GroupPartitionId(grpId, partId);
            int partitionGeneration = this.partGenerationMap.getOrDefault((Object)groupPartitionId, 1);
            assert (partitionGeneration > 0) : "groupPartitionId=" + groupPartitionId + ", partitionGeneration=" + partitionGeneration;
            return partitionGeneration;
        }

        public LoadedPagesMap loadedPages() {
            return this.loadedPages;
        }

        public PagePool pool() {
            return this.pool;
        }

        private int incrementPartGeneration(int grpId, int partId) {
            assert (this.getWriteHoldCount() > 0) : "grpId=" + grpId + ", partId=" + partId;
            GroupPartitionId groupPartitionId = new GroupPartitionId(grpId, partId);
            int partitionGeneration = this.partGenerationMap.getOrDefault((Object)groupPartitionId, 1);
            if (partitionGeneration == Integer.MAX_VALUE) {
                LOG.info("Partition generation overflow [grpId={}, partId={}]", grpId, partId);
                this.partGenerationMap.put((Object)groupPartitionId, 1);
                return 1;
            }
            this.partGenerationMap.put((Object)groupPartitionId, partitionGeneration + 1);
            return partitionGeneration + 1;
        }

        private void resetGroupPartitionsGeneration(int grpId) {
            assert (this.getWriteHoldCount() > 0) : "grpId=" + grpId;
            this.partGenerationMap.keySet().removeIf(grpPart -> grpPart.getGroupId() == grpId);
        }

        public PageIoRegistry ioRegistry() {
            return PersistentPageMemory.this.ioRegistry;
        }

        public CheckpointPages checkpointPages() {
            return this.checkpointPages;
        }

        boolean shouldThrottle(double dirtyRatioThreshold) {
            return this.dirtyPagesCntr.doubleValue() > dirtyRatioThreshold * (double)this.pages();
        }
    }
}

