/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.freelist;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.Storable;
import org.apache.ignite3.internal.pagememory.freelist.CorruptedFreeListException;
import org.apache.ignite3.internal.pagememory.freelist.FreeList;
import org.apache.ignite3.internal.pagememory.freelist.PagesList;
import org.apache.ignite3.internal.pagememory.io.DataPageIo;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.reuse.LongListReuseBag;
import org.apache.ignite3.internal.pagememory.reuse.ReuseBag;
import org.apache.ignite3.internal.pagememory.reuse.ReuseList;
import org.apache.ignite3.internal.pagememory.util.PageHandler;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class FreeListImpl
extends PagesList
implements FreeList,
ReuseList {
    private static final IgniteLogger LOG = Loggers.forClass(FreeListImpl.class);
    private static final int BUCKETS = 256;
    private static final int REUSE_BUCKET = 255;
    private static final Integer COMPLETE = Integer.MAX_VALUE;
    private static final Integer FAIL_I = Integer.MIN_VALUE;
    private static final Long FAIL_L = Long.MAX_VALUE;
    private static final int MIN_PAGE_FREE_SPACE = 8;
    private final int shift;
    private final AtomicReferenceArray<PagesList.Stripe[]> buckets = new AtomicReferenceArray(256);
    private final AtomicReferenceArray<PagesList.PagesCache> bucketCaches = new AtomicReferenceArray(256);
    private final int minSizeForDataPage;
    @Nullable
    private final AtomicLong pageListCacheLimit;
    private volatile boolean closed;
    private final WriteRowHandler writeRowHnd = new WriteRowHandler();
    private final WriteRowsHandler writeRowsHnd = new WriteRowsHandler();
    private final PageHandler<ReuseBag, Long> rmvRow;

    public FreeListImpl(String freeListNamePrefix, int grpId, int partId, PageMemory pageMem, long metaPageId, boolean initNew, @Nullable AtomicLong pageListCacheLimit) throws IgniteInternalCheckedException {
        super(freeListNamePrefix, grpId, partId, pageMem, LOG, 256, metaPageId);
        int pageSize;
        this.pageListCacheLimit = pageListCacheLimit;
        this.reuseList = this;
        this.rmvRow = new RemoveRowHandler(grpId == 0);
        assert (IgniteUtils.isPow2(pageSize)) : "Page size must be a power of 2: " + pageSize;
        assert (IgniteUtils.isPow2(256));
        assert (256 <= pageSize) : pageSize;
        this.minSizeForDataPage = pageSize - 66;
        int shift = 0;
        for (pageSize = pageMem.pageSize(); pageSize > 256; pageSize >>>= 1) {
            ++shift;
        }
        this.shift = shift;
        this.init(metaPageId, initNew);
    }

    public long freeSpace() {
        long freeSpace = 0L;
        for (int b = 254; b > 0; --b) {
            long perPageFreeSpace = b << this.shift;
            long pages = this.bucketsSize.get(b);
            freeSpace += pages * perPageFreeSpace;
        }
        return freeSpace;
    }

    @Override
    public void dumpStatistics(IgniteLogger log) {
        long dataPages = 0L;
        boolean dumpBucketsInfo = false;
        for (int b = 0; b < 256; ++b) {
            long size = this.bucketsSize.get(b);
            if (this.isReuseBucket(b)) continue;
            dataPages += size;
        }
        if (dataPages > 0L && log.isInfoEnabled()) {
            log.info("FreeListImpl [name={}, buckets={}, dataPages={}, reusePages={}]", this.name(), 256, dataPages, this.bucketsSize.get(255));
        }
    }

    private int bucket(int freeSpace, boolean allowReuse) {
        assert (freeSpace > 0) : freeSpace;
        int bucket = freeSpace >>> this.shift;
        assert (bucket >= 0 && bucket < 256) : bucket;
        if (!allowReuse && this.isReuseBucket(bucket)) {
            --bucket;
        }
        return bucket;
    }

    @Override
    protected int getBucketIndex(int freeSpace) {
        return freeSpace > 8 ? this.bucket(freeSpace, false) : -1;
    }

    private long allocateDataPage(int part) throws IgniteInternalCheckedException {
        assert (part <= 65500);
        return this.pageMem.allocatePage(this.reuseList, this.grpId, part, (byte)1);
    }

    @Override
    public void insertDataRow(Storable row) throws IgniteInternalCheckedException {
        int written = 0;
        try {
            while ((written = this.writeSinglePage(row, written)) != COMPLETE) {
            }
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to insert data row", t, this.grpId, new long[0]);
        }
    }

    @Override
    public void insertDataRows(Collection<? extends Storable> rows) throws IgniteInternalCheckedException {
        try {
            CachedIterator it = new CachedIterator(rows.iterator());
            int written = COMPLETE;
            while (written != COMPLETE || it.hasNext()) {
                if (written == COMPLETE) {
                    written = this.writeWholePages(it.next());
                    continue;
                }
                Storable row = it.get();
                DataPageIo initIo = null;
                long pageId = this.takePage(row.size() - written, row);
                if (pageId == 0L) {
                    pageId = this.allocateDataPage(row.partition());
                    initIo = DataPageIo.VERSIONS.latest();
                }
                written = this.write(pageId, this.writeRowsHnd, initIo, it, written, FAIL_I);
                assert (written != FAIL_I);
            }
        }
        catch (RuntimeException e) {
            throw new CorruptedFreeListException("Failed to insert data rows", (Throwable)e, this.grpId, new long[0]);
        }
    }

    private int writeWholePages(Storable row) throws IgniteInternalCheckedException {
        assert (row.link() == 0L) : row.link();
        int written = 0;
        int rowSize = row.size();
        while (rowSize - written >= this.minSizeForDataPage) {
            written = this.writeSinglePage(row, written);
        }
        return written;
    }

    private int writeSinglePage(Storable row, int written) throws IgniteInternalCheckedException {
        DataPageIo initIo = null;
        long pageId = this.takePage(row.size() - written, row);
        if (pageId == 0L) {
            pageId = this.allocateDataPage(row.partition());
            initIo = DataPageIo.VERSIONS.latest();
        }
        written = this.write(pageId, this.writeRowHnd, initIo, row, written, FAIL_I);
        assert (written != FAIL_I);
        return written;
    }

    private long takePage(int size, Storable row) throws IgniteInternalCheckedException {
        long pageId = 0L;
        if (size < this.minSizeForDataPage) {
            for (int b = this.bucket(size, false) + 1; b < 255 && (pageId = this.takeEmptyPage(b, DataPageIo.VERSIONS)) == 0L; ++b) {
            }
        }
        if (pageId == 0L) {
            if (this.reuseList == this) {
                pageId = this.takeEmptyPage(255, DataPageIo.VERSIONS);
            } else {
                pageId = this.reuseList.takeRecycledPage();
                if (pageId != 0L) {
                    pageId = this.reuseList.initRecycledPage(pageId, (byte)1, DataPageIo.VERSIONS.latest());
                }
            }
        }
        if (pageId == 0L) {
            return 0L;
        }
        assert (PageIdUtils.flag(pageId) == 1) : "rowVersions=" + DataPageIo.VERSIONS + ", pageId=" + PageIdUtils.toDetailString(pageId);
        return PageIdUtils.changePartitionId(pageId, row.partition());
    }

    @Override
    public <S, R> R updateDataRow(long link, PageHandler<S, R> pageHnd, S arg) throws IgniteInternalCheckedException {
        assert (link != 0L);
        try {
            long pageId = PageIdUtils.pageId(link);
            int itemId = PageIdUtils.itemId(link);
            R updRes = this.write(pageId, pageHnd, arg, itemId, null);
            assert (updRes != null);
            return updRes;
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to update data row", t, this.grpId, new long[0]);
        }
    }

    @Override
    public void removeDataRowByLink(long link) throws IgniteInternalCheckedException {
        assert (link != 0L);
        try {
            long pageId = PageIdUtils.pageId(link);
            int itemId = PageIdUtils.itemId(link);
            LongListReuseBag bag = new LongListReuseBag();
            long nextLink = this.write(pageId, this.rmvRow, bag, itemId, FAIL_L);
            assert (nextLink != FAIL_L);
            while (nextLink != 0L) {
                itemId = PageIdUtils.itemId(nextLink);
                pageId = PageIdUtils.pageId(nextLink);
                nextLink = this.write(pageId, this.rmvRow, bag, itemId, FAIL_L);
                assert (nextLink != FAIL_L);
            }
            this.reuseList.addForRecycle(bag);
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to remove data by link", t, this.grpId, new long[0]);
        }
    }

    @Override
    protected PagesList.Stripe[] getBucket(int bucket) {
        return this.buckets.get(bucket);
    }

    @Override
    protected boolean casBucket(int bucket, PagesList.Stripe[] exp, PagesList.Stripe[] upd) {
        boolean res = this.buckets.compareAndSet(bucket, exp, upd);
        if (this.log.isDebugEnabled()) {
            this.log.debug("CAS bucket [list=" + this.name() + ", bucket=" + bucket + ", old=" + Arrays.toString(exp) + ", new=" + Arrays.toString(upd) + ", res=" + res + "]", new Object[0]);
        }
        return res;
    }

    @Override
    protected boolean isReuseBucket(int bucket) {
        return bucket == 255;
    }

    @Override
    protected PagesList.PagesCache getBucketCache(int bucket, boolean create) {
        PagesList.PagesCache pagesCache = this.bucketCaches.get(bucket);
        if (pagesCache == null && create && !this.bucketCaches.compareAndSet(bucket, null, pagesCache = new PagesList.PagesCache(this.pageListCacheLimit))) {
            pagesCache = this.bucketCaches.get(bucket);
        }
        return pagesCache;
    }

    public int emptyDataPages() {
        return (int)this.bucketsSize.get(255);
    }

    @Override
    public void addForRecycle(ReuseBag bag) throws IgniteInternalCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            this.put(bag, 0L, 0L, 255);
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to add page for recycle", t, this.grpId, new long[0]);
        }
    }

    @Override
    public long takeRecycledPage() throws IgniteInternalCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            return this.takeEmptyPage(255, null);
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to take recycled page", t, this.grpId, new long[0]);
        }
    }

    @Override
    public long initRecycledPage(long pageId, byte flag, PageIo initIo) throws IgniteInternalCheckedException {
        return this.initRecycledPage0(pageId, flag, initIo);
    }

    @Override
    public long recycledPagesCount() throws IgniteInternalCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        try {
            return this.storedPagesCount(255);
        }
        catch (AssertionError e) {
            throw this.corruptedFreeListException((Throwable)((Object)e), new long[0]);
        }
        catch (Error | IgniteInternalCheckedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CorruptedFreeListException("Failed to count recycled pages", t, this.grpId, new long[0]);
        }
    }

    @Override
    public void saveMetadata() throws IgniteInternalCheckedException {
        if (!this.closed) {
            super.saveMetadata();
        }
    }

    public String toString() {
        return "FreeListImpl [name=" + this.name() + "]";
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private class WriteRowHandler
    implements PageHandler<Storable, Integer> {
        private WriteRowHandler() {
        }

        @Override
        public Integer run(int cacheId, long pageId, long page, long pageAddr, PageIo iox, Storable row, int written) throws IgniteInternalCheckedException {
            written = this.addRow(pageId, pageAddr, iox, row, written);
            this.putPage(((DataPageIo)iox).getFreeSpace(pageAddr), pageId, pageAddr);
            return written;
        }

        protected Integer addRow(long pageId, long pageAddr, PageIo iox, Storable row, int written) throws IgniteInternalCheckedException {
            DataPageIo io = (DataPageIo)iox;
            int rowSize = row.size();
            int oldFreeSpace = io.getFreeSpace(pageAddr);
            assert (oldFreeSpace > 0) : oldFreeSpace;
            written = written == 0 && oldFreeSpace >= rowSize ? this.addRowFull(pageId, pageAddr, io, row, rowSize) : this.addRowFragment(pageId, pageAddr, io, row, written, rowSize);
            return written == rowSize ? COMPLETE : written;
        }

        protected int addRowFull(long pageId, long pageAddr, DataPageIo io, Storable row, int rowSize) throws IgniteInternalCheckedException {
            io.addRow(pageId, pageAddr, row, rowSize, FreeListImpl.this.pageSize());
            return rowSize;
        }

        protected int addRowFragment(long pageId, long pageAddr, DataPageIo io, Storable row, int written, int rowSize) {
            int payloadSize = io.addRowFragment(FreeListImpl.this.pageMem, pageId, pageAddr, row, written, rowSize, FreeListImpl.this.pageSize());
            assert (payloadSize > 0) : payloadSize;
            return written + payloadSize;
        }

        protected void putPage(int freeSpace, long pageId, long pageAddr) throws IgniteInternalCheckedException {
            if (freeSpace > 8) {
                int bucket = FreeListImpl.this.bucket(freeSpace, false);
                FreeListImpl.this.put(null, pageId, pageAddr, bucket);
            }
        }
    }

    private final class WriteRowsHandler
    implements PageHandler<CachedIterator, Integer> {
        private WriteRowsHandler() {
        }

        @Override
        public Integer run(int cacheId, long pageId, long page, long pageAddr, PageIo iox, CachedIterator it, int written) throws IgniteInternalCheckedException {
            DataPageIo io = (DataPageIo)iox;
            while (written != COMPLETE || it.hasNext()) {
                Storable row = it.get();
                if (written == COMPLETE) {
                    row = it.next();
                    written = FreeListImpl.this.writeWholePages(row);
                    if (written == COMPLETE) continue;
                    if (io.getFreeSpace(pageAddr) < row.size() - written) break;
                }
                written = FreeListImpl.this.writeRowHnd.addRow(pageId, pageAddr, io, row, written);
                assert (written == COMPLETE);
            }
            FreeListImpl.this.writeRowHnd.putPage(io.getFreeSpace(pageAddr), pageId, pageAddr);
            return written;
        }
    }

    private final class RemoveRowHandler
    implements PageHandler<ReuseBag, Long> {
        private final boolean maskPartId;

        RemoveRowHandler(boolean maskPartId) {
            this.maskPartId = maskPartId;
        }

        @Override
        public Long run(int cacheId, long pageId, long page, long pageAddr, PageIo iox, ReuseBag reuseBag, int itemId) throws IgniteInternalCheckedException {
            DataPageIo io = (DataPageIo)iox;
            int oldFreeSpace = io.getFreeSpace(pageAddr);
            assert (oldFreeSpace >= 0) : oldFreeSpace;
            long nextLink = io.removeRow(pageAddr, itemId, FreeListImpl.this.pageSize());
            int newFreeSpace = io.getFreeSpace(pageAddr);
            if (newFreeSpace > 8) {
                int oldBucket;
                boolean putIsNeeded;
                int newBucket = FreeListImpl.this.bucket(newFreeSpace, false);
                boolean bl = putIsNeeded = oldFreeSpace <= 8;
                if (!putIsNeeded && (oldBucket = FreeListImpl.this.bucket(oldFreeSpace, false)) != newBucket) {
                    pageId = this.maskPartId ? PageIdUtils.maskPartitionId(pageId) : pageId;
                    putIsNeeded = FreeListImpl.this.removeDataPage(pageId, pageAddr, io, oldBucket);
                }
                if (io.isEmpty(pageAddr)) {
                    if (putIsNeeded) {
                        reuseBag.addFreePage(FreeListImpl.recyclePage(pageId, pageAddr));
                    }
                } else if (putIsNeeded) {
                    FreeListImpl.this.put(null, pageId, pageAddr, newBucket);
                }
            }
            return nextLink;
        }
    }

    private static class CachedIterator
    implements Iterator<Storable> {
        private final Iterator<? extends Storable> it;
        private Storable next;

        CachedIterator(Iterator<? extends Storable> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Storable next() {
            this.next = this.it.next();
            return this.next;
        }

        Storable get() {
            return this.next;
        }
    }
}

