/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.message.ClusterNodeMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeStartResponseMessageBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class HandshakeStartResponseMessageDeserializer
implements MessageDeserializer<HandshakeStartResponseMessage> {
    private final HandshakeStartResponseMessageBuilder msg;

    HandshakeStartResponseMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeStartResponseMessage();
    }

    @Override
    public Class<HandshakeStartResponseMessage> klass() {
        return HandshakeStartResponseMessage.class;
    }

    @Override
    public HandshakeStartResponseMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeStartResponseMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ClusterNodeMessage tmp = (ClusterNodeMessage)reader.readMessage("clientNode");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.clientNode(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                short tmp = reader.readShort("connectionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.connectionId(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("receivedCount");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.receivedCount(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeStartResponseMessage.class);
    }
}

