/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.recovery.message.HandshakeFinishMessage;
import org.apache.ignite3.internal.network.recovery.message.HandshakeFinishMessageBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class HandshakeFinishMessageDeserializer
implements MessageDeserializer<HandshakeFinishMessage> {
    private final HandshakeFinishMessageBuilder msg;

    HandshakeFinishMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeFinishMessage();
    }

    @Override
    public Class<HandshakeFinishMessage> klass() {
        return HandshakeFinishMessage.class;
    }

    @Override
    public HandshakeFinishMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeFinishMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("receivedCount");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.receivedCount(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeFinishMessage.class);
    }
}

