/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.recovery.message;

import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.recovery.message.AcknowledgementMessage;
import org.apache.ignite3.internal.network.recovery.message.AcknowledgementMessageBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class AcknowledgementMessageDeserializer
implements MessageDeserializer<AcknowledgementMessage> {
    private final AcknowledgementMessageBuilder msg;

    AcknowledgementMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.acknowledgementMessage();
    }

    @Override
    public Class<AcknowledgementMessage> klass() {
        return AcknowledgementMessage.class;
    }

    @Override
    public AcknowledgementMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.acknowledgementMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("receivedMessages");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.receivedMessages(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(AcknowledgementMessage.class);
    }
}

