/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network;

import java.io.IOException;
import java.util.UUID;
import org.apache.ignite3.internal.network.ClusterNodeImpl;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.apache.ignite3.network.NetworkAddress;
import org.apache.ignite3.network.NodeMetadata;

public class ClusterNodeSerializer
extends VersionedSerializer<InternalClusterNode> {
    public static final ClusterNodeSerializer INSTANCE = new ClusterNodeSerializer();

    @Override
    protected void writeExternalData(InternalClusterNode node, IgniteDataOutput out) throws IOException {
        out.writeUuid(node.id());
        out.writeUTF(node.name());
        out.writeUTF(node.address().host());
        out.writeVarInt(node.address().port());
        NodeMetadata metadata = node.nodeMetadata();
        out.writeBoolean(metadata != null);
        if (metadata != null) {
            out.writeUTF(metadata.restHost());
            out.writeVarInt(metadata.httpPort());
            out.writeVarInt(metadata.httpsPort());
        }
    }

    @Override
    protected InternalClusterNode readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        UUID id = in.readUuid();
        String name = in.readUTF();
        NetworkAddress address = new NetworkAddress(in.readUTF(), in.readVarIntAsInt());
        boolean hasMetadata = in.readBoolean();
        NodeMetadata metadata = hasMetadata ? new NodeMetadata(in.readUTF(), in.readVarIntAsInt(), in.readVarIntAsInt()) : null;
        return new ClusterNodeImpl(id, name, address, metadata);
    }
}

