/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics.sources;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.metrics.AbstractMetricSource;
import org.apache.ignite3.internal.metrics.IntGauge;
import org.apache.ignite3.internal.metrics.LongGauge;
import org.apache.ignite3.internal.metrics.Metric;
import org.apache.ignite3.internal.thread.StripedThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class StripedThreadPoolMetricSource
extends AbstractMetricSource<Holder> {
    private final StripedThreadPoolExecutor exec;

    public StripedThreadPoolMetricSource(String name, @Nullable String description, StripedThreadPoolExecutor exec) {
        this(name, (String)null, "thread.pools", exec);
    }

    public StripedThreadPoolMetricSource(String name, @Nullable String description, @Nullable String group, StripedThreadPoolExecutor exec) {
        super(name, description, group);
        this.exec = exec;
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        final List<Metric> executorMetrics;

        Holder() {
            this.executorMetrics = new ArrayList<Metric>(StripedThreadPoolMetricSource.this.exec.concurrencyLevel() * 9);
            this.executorMetrics.add(new IntGauge("ConcurrencyLevel", "Concurrency level of the striped thread pool executor.", StripedThreadPoolMetricSource.this.exec::concurrencyLevel));
            for (int i = 0; i < StripedThreadPoolMetricSource.this.exec.concurrencyLevel(); ++i) {
                assert (StripedThreadPoolMetricSource.this.exec.stripeExecutor(i) instanceof ThreadPoolExecutor) : "Stripe executor should be an instance of ThreadPoolExecutor [class=" + this$0.exec.stripeExecutor(i).getClass() + ", idx=" + i + "]";
                ThreadPoolExecutor stripe = (ThreadPoolExecutor)StripedThreadPoolMetricSource.this.exec.stripeExecutor(i);
                String stripeName = "stripe." + i + ".";
                this.executorMetrics.add(new IntGauge(stripeName + "ActiveCount", "Approximate number of threads that are actively executing tasks.", stripe::getActiveCount));
                this.executorMetrics.add(new LongGauge(stripeName + "CompletedTaskCount", "Approximate total number of tasks that have completed execution.", stripe::getCompletedTaskCount));
                this.executorMetrics.add(new IntGauge(stripeName + "CorePoolSize", "The core number of threads.", stripe::getCorePoolSize));
                this.executorMetrics.add(new IntGauge(stripeName + "LargestPoolSize", "Largest number of threads that have ever simultaneously been in the pool.", stripe::getLargestPoolSize));
                this.executorMetrics.add(new IntGauge(stripeName + "MaximumPoolSize", "The maximum allowed number of threads.", stripe::getMaximumPoolSize));
                this.executorMetrics.add(new IntGauge(stripeName + "PoolSize", "Current number of threads in the pool.", stripe::getPoolSize));
                this.executorMetrics.add(new LongGauge(stripeName + "TaskCount", "Approximate total number of tasks that have been scheduled for execution.", stripe::getTaskCount));
                this.executorMetrics.add(new IntGauge(stripeName + "QueueSize", "Current size of the execution queue.", () -> stripe.getQueue().size()));
                this.executorMetrics.add(new LongGauge(stripeName + "KeepAliveTime", "Thread keep-alive time, which is the amount of time which threads in excess of the core pool size may remain idle before being terminated.", () -> stripe.getKeepAliveTime(TimeUnit.MILLISECONDS)));
            }
        }

        @Override
        public Iterable<Metric> metrics() {
            return this.executorMetrics;
        }
    }
}

