/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.metastorage.dsl.ConditionType;
import org.apache.ignite3.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite3.internal.metastorage.dsl.ValueConditionBuilder;
import org.apache.ignite3.internal.metastorage.dsl.ValueConditionSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ValueConditionImpl
implements SimpleCondition.ValueCondition,
Cloneable {
    public static final short GROUP_TYPE = 222;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final ByteBuffer key;
    @IgniteToStringInclude
    private final ConditionType type;
    @IgniteToStringInclude
    private final ByteBuffer value;

    private ValueConditionImpl(ByteBuffer key, ConditionType type, ByteBuffer value) {
        this.key = key;
        this.type = type;
        this.value = value;
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public ConditionType type() {
        return this.type;
    }

    @Override
    public ByteBuffer value() {
        return this.value;
    }

    public MessageSerializer serializer() {
        return ValueConditionSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 222;
    }

    public String toString() {
        return S.toString(ValueConditionImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ValueConditionImpl otherMessage = (ValueConditionImpl)other;
        return Objects.equals(this.key, otherMessage.key) && Objects.equals((Object)this.type, (Object)otherMessage.type) && Objects.equals(this.value, otherMessage.value);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.key, this.type, this.value});
        return result;
    }

    @Override
    public ValueConditionImpl clone() {
        try {
            return (ValueConditionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ValueConditionBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ValueConditionBuilder {
        private ByteBuffer key;
        private ConditionType type;
        private ByteBuffer value;

        private Builder() {
        }

        @Override
        public ValueConditionBuilder key(ByteBuffer key) {
            Objects.requireNonNull(key, "key is not marked @Nullable");
            this.key = key;
            return this;
        }

        @Override
        public ValueConditionBuilder type(ConditionType type) {
            Objects.requireNonNull(type, "type is not marked @Nullable");
            this.type = type;
            return this;
        }

        @Override
        public ValueConditionBuilder value(ByteBuffer value) {
            Objects.requireNonNull(value, "value is not marked @Nullable");
            this.value = value;
            return this;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public ConditionType type() {
            return this.type;
        }

        @Override
        public ByteBuffer value() {
            return this.value;
        }

        @Override
        public SimpleCondition.ValueCondition build() {
            return new ValueConditionImpl(Objects.requireNonNull(this.key, "key is not marked @Nullable"), Objects.requireNonNull(this.type, "type is not marked @Nullable"), Objects.requireNonNull(this.value, "value is not marked @Nullable"));
        }

        @Override
        public SimpleCondition.ValueCondition buildDeserialized() {
            return new ValueConditionImpl(this.key, this.type, this.value);
        }
    }
}

