/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.marshaller;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.catalog.annotations.Column;
import org.apache.ignite3.internal.marshaller.Creator;
import org.apache.ignite3.internal.marshaller.FieldAccessor;
import org.apache.ignite3.internal.marshaller.MarshallerReader;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.jetbrains.annotations.NotNull;

class CreatorFromAnnotatedConstructorParameters
implements Creator {
    private final MethodHandle mhFixedArity;
    private final List<String> argsColumnNames;

    CreatorFromAnnotatedConstructorParameters(Constructor<?> ctor) {
        assert (ctor.getParameterCount() > 0);
        this.argsColumnNames = CreatorFromAnnotatedConstructorParameters.argsNames(ctor);
        this.mhFixedArity = CreatorFromAnnotatedConstructorParameters.unreflect(ctor);
    }

    @Override
    public Object createInstance(FieldAccessor[] accessors, MarshallerReader reader) {
        try {
            NamedArguments args = this.readArgs(accessors, reader);
            return this.mhFixedArity.invokeWithArguments(args.values);
        }
        catch (MarshallerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to instantiate class", e);
        }
    }

    private static List<String> argsNames(Constructor<?> ctor) {
        Parameter[] creatorParams = ctor.getParameters();
        if (Arrays.stream(creatorParams).anyMatch(p -> !p.isAnnotationPresent(Column.class))) {
            throw new IllegalArgumentException("All constructor parameters must be annotated with @Column");
        }
        return Arrays.stream(creatorParams).map(p -> p.getAnnotation(Column.class)).map(column -> {
            String columnName = column.value();
            if (columnName.isBlank()) {
                throw new IllegalArgumentException("@Column name can not be blank in constructor declaration");
            }
            return IgniteNameUtils.parseIdentifier(columnName);
        }).collect(Collectors.toList());
    }

    private static MethodHandle unreflect(Constructor<?> ctor) {
        try {
            ctor.setAccessible(true);
            return MethodHandles.lookup().unreflectConstructor(ctor).asFixedArity();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to create method handle from constructor", e);
        }
    }

    @NotNull
    private NamedArguments readArgs(FieldAccessor[] accessors, MarshallerReader reader) {
        NamedArguments args = new NamedArguments(this.argsColumnNames);
        for (int fldIdx = 0; fldIdx < accessors.length; ++fldIdx) {
            FieldAccessor a = accessors[fldIdx];
            Object val = a.read(reader);
            args.add(a.getColumnName(), val);
        }
        return args;
    }

    private static class NamedArguments {
        private final List<String> names;
        private final Object[] values;

        private NamedArguments(List<String> names) {
            this.names = names;
            this.values = new Object[names.size()];
        }

        void add(String name, Object value) {
            int idx = this.names.indexOf(name);
            if (idx < 0) {
                return;
            }
            this.values[idx] = value;
        }
    }
}

