/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.lang;

import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.sql.engine.api.expressions.ExpressionEvaluationException;
import org.apache.ignite3.internal.sql.engine.exec.mapping.MappingException;
import org.apache.ignite3.internal.sql.engine.message.UnknownNodeException;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.CursorClosedException;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.TraceableException;
import org.apache.ignite3.sql.SqlException;

public class SqlExceptionMapperUtil {
    public static Throwable mapToPublicSqlException(Throwable origin) {
        Throwable unwrapped = ExceptionUtils.unwrapCause(origin);
        if (unwrapped instanceof MappingException) {
            return new SqlException(ErrorGroups.Sql.MAPPING_ERR, unwrapped.getMessage());
        }
        if (unwrapped instanceof UnknownNodeException) {
            return new SqlException(ErrorGroups.Common.NODE_LEFT_ERR, "Node left the cluster. Node: " + ((UnknownNodeException)unwrapped).nodeName());
        }
        if (unwrapped instanceof ExpressionEvaluationException) {
            return new SqlException(ErrorGroups.Sql.RUNTIME_ERR, unwrapped.getMessage());
        }
        Throwable e = IgniteExceptionMapperUtil.mapToPublicException(origin);
        if (e instanceof Error) {
            return e;
        }
        if (e instanceof SqlException || e instanceof CursorClosedException) {
            return e;
        }
        if (e instanceof TraceableException) {
            TraceableException traceable = (TraceableException)((Object)e);
            return new SqlException(traceable.traceId(), traceable.code(), e.getMessage(), e);
        }
        return new SqlException(ErrorGroups.Common.INTERNAL_ERR, origin);
    }
}

