/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.index;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.index.ChangeIndexStatusTaskController;
import org.apache.ignite3.internal.index.ChangeIndexStatusTaskScheduler;
import org.apache.ignite3.internal.index.IndexAvailabilityController;
import org.apache.ignite3.internal.index.IndexBuildController;
import org.apache.ignite3.internal.index.IndexBuilder;
import org.apache.ignite3.internal.index.IndexManager;
import org.apache.ignite3.internal.index.RetryingFinalTransactionStateResolver;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.metastorage.Revisions;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.partition.replicator.PartitionReplicaLifecycleManager;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.placementdriver.wrappers.ExecutorInclinedPlacementDriver;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.impl.TransactionStateResolver;
import org.apache.ignite3.internal.tx.impl.TxMessageSender;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;

public class IndexBuildingManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(IndexBuildingManager.class);
    private final MetaStorageManager metaStorageManager;
    private final ThreadPoolExecutor executor;
    private final IndexBuilder indexBuilder;
    private final IndexAvailabilityController indexAvailabilityController;
    private final IndexBuildController indexBuildController;
    private final ChangeIndexStatusTaskController changeIndexStatusTaskController;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    public IndexBuildingManager(String nodeName, ReplicaService replicaService, CatalogManager catalogManager, MetaStorageManager metaStorageManager, IndexManager indexManager, IndexMetaStorage indexMetaStorage, PlacementDriver placementDriver, ClusterService clusterService, LogicalTopologyService logicalTopologyService, ClockService clockService, FailureProcessor failureProcessor, LowWatermark lowWatermark, TxManager txManager, PartitionReplicaLifecycleManager partitionReplicaLifecycleManager, MetricManager metricManager) {
        this.metaStorageManager = metaStorageManager;
        int threadCount = Runtime.getRuntime().availableProcessors();
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create(nodeName, "build-index", LOG, ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE));
        this.executor.allowCoreThreadTimeOut(true);
        TransactionStateResolver transactionStateResolver = new TransactionStateResolver(txManager, clockService, clusterService.topologyService(), clusterService.messagingService(), new ExecutorInclinedPlacementDriver(placementDriver, this.executor), new TxMessageSender(clusterService.messagingService(), replicaService, clockService));
        this.indexBuilder = new IndexBuilder(this.executor, replicaService, failureProcessor, new RetryingFinalTransactionStateResolver(transactionStateResolver, this.executor), indexMetaStorage, metricManager);
        this.indexAvailabilityController = new IndexAvailabilityController(catalogManager, metaStorageManager, failureProcessor, this.indexBuilder);
        this.indexBuildController = new IndexBuildController(this.indexBuilder, indexManager, catalogManager, clusterService, placementDriver, clockService, partitionReplicaLifecycleManager, failureProcessor);
        ChangeIndexStatusTaskScheduler indexTaskScheduler = new ChangeIndexStatusTaskScheduler(catalogManager, clusterService, logicalTopologyService, clockService, placementDriver, indexMetaStorage, failureProcessor, this.executor);
        this.changeIndexStatusTaskController = new ChangeIndexStatusTaskController(catalogManager, placementDriver, clusterService, lowWatermark, indexTaskScheduler);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync(this.busyLock, () -> {
            CompletableFuture<Revisions> recoveryFinishedFuture = this.metaStorageManager.recoveryFinishedFuture();
            assert (recoveryFinishedFuture.isDone());
            long recoveryRevision = recoveryFinishedFuture.join().revision();
            this.indexAvailabilityController.start(recoveryRevision);
            this.changeIndexStatusTaskController.start();
            this.indexBuildController.start();
            return CompletableFutures.nullCompletedFuture();
        });
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAllManually(this.indexBuilder, this.indexAvailabilityController, this.indexBuildController, this.changeIndexStatusTaskController, () -> IgniteUtils.shutdownAndAwaitTermination(this.executor, 10L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

