/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.failure.handlers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.NodeStopper;
import org.apache.ignite3.internal.failure.handlers.AbstractFailureHandler;
import org.apache.ignite3.internal.failure.handlers.configuration.StopNodeOrHaltFailureHandlerView;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.thread.IgniteThread;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.TestOnly;

public class StopNodeOrHaltFailureHandler
extends AbstractFailureHandler {
    private static final IgniteLogger LOG = Loggers.forClass(StopNodeOrHaltFailureHandler.class);
    private static final int KILL_EXIT_CODE = 130;
    private String nodeName;
    @IgniteToStringExclude
    private final NodeStopper nodeStopper;
    private final boolean tryStop;
    private final long timeout;

    @TestOnly
    public StopNodeOrHaltFailureHandler(NodeStopper nodeStopper, boolean tryStop, long timeout) {
        this.nodeStopper = nodeStopper;
        this.tryStop = tryStop;
        this.timeout = timeout;
    }

    public StopNodeOrHaltFailureHandler(String nodeName, NodeStopper nodeStopper, StopNodeOrHaltFailureHandlerView view) {
        this.nodeName = nodeName;
        this.nodeStopper = nodeStopper;
        this.tryStop = view.tryStop();
        this.timeout = view.timeoutMillis();
    }

    @Override
    protected boolean handle(FailureContext failureCtx) {
        if (this.tryStop) {
            CountDownLatch latch = new CountDownLatch(1);
            IgniteThreadFactory stopThreadFactory = IgniteThreadFactory.create(this.nodeName, "node-stopper", true, LOG, ThreadOperation.values());
            IgniteThread stopperThread = stopThreadFactory.newThread(() -> {
                this.nodeStopper.stopNode();
                latch.countDown();
            });
            stopperThread.start();
            IgniteThreadFactory haltThreadFactory = IgniteThreadFactory.create(this.nodeName, "jvm-halt-on-stop-timeout", true, LOG, ThreadOperation.values());
            IgniteThread haltOnStopTimeoutThread = haltThreadFactory.newThread(() -> {
                try {
                    if (!latch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                        Runtime.getRuntime().halt(130);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            haltOnStopTimeoutThread.start();
        } else {
            Runtime.getRuntime().halt(130);
        }
        return true;
    }

    public long timeout() {
        return this.timeout;
    }

    public boolean tryStop() {
        return this.tryStop;
    }

    @Override
    public String toString() {
        return S.toString(StopNodeOrHaltFailureHandler.class, this, super.toString());
    }
}

