/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.eventlog.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collection;
import org.apache.ignite3.internal.eventlog.api.Event;
import org.apache.ignite3.internal.eventlog.event.EventUser;
import org.apache.ignite3.internal.eventlog.ser.EventSerializer;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.lang.ErrorGroups;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.jetbrains.annotations.Nullable;

public class JacksonBasedJsonSerializer
implements EventSerializer {
    private final ObjectMapper mapper = new ObjectMapper();

    public JacksonBasedJsonSerializer() {
        this.mapper.registerModule(JacksonBasedJsonSerializer.eventUserModule());
        this.mapper.registerModule(JacksonBasedJsonSerializer.rbacModule());
    }

    private static Module eventUserModule() {
        SimpleModule module = new SimpleModule("EventUser");
        module.addSerializer(EventUser.class, (JsonSerializer)new EventUserJacksonSerializer());
        return module;
    }

    private static Module rbacModule() {
        SimpleModule module = new SimpleModule("RbacModule");
        module.addSerializer(Privilege.class, (JsonSerializer)new PrivilegeJacksonSerializer());
        module.addSerializer(Selector.class, (JsonSerializer)new SelectorJacksonSerializer());
        return module;
    }

    @Override
    public String serialize(Event event) {
        try {
            return this.mapper.writeValueAsString((Object)event);
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Failed to serialize event", (Throwable)e);
        }
    }

    @Override
    public byte[] serialize(Collection<Event> event) {
        try {
            return this.mapper.writeValueAsBytes(event);
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Failed to serialize events", (Throwable)e);
        }
    }

    private static class EventUserJacksonSerializer
    extends StdSerializer<EventUser> {
        EventUserJacksonSerializer() {
            this(null);
        }

        EventUserJacksonSerializer(@Nullable Class<EventUser> e) {
            super(e);
        }

        public void serialize(EventUser value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField("username", value.username());
            jgen.writeStringField("authenticationProvider", value.authenticationProvider());
            jgen.writeEndObject();
        }
    }

    private static class PrivilegeJacksonSerializer
    extends StdSerializer<Privilege> {
        PrivilegeJacksonSerializer() {
            this(null);
        }

        PrivilegeJacksonSerializer(Class<Privilege> e) {
            super(e);
        }

        public void serialize(Privilege value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeObjectField("action", (Object)value.action().name());
            jgen.writeObjectField("on", (Object)value.selector());
            jgen.writeEndObject();
        }
    }

    private static class SelectorJacksonSerializer
    extends StdSerializer<Selector> {
        SelectorJacksonSerializer() {
            this(null);
        }

        SelectorJacksonSerializer(Class<Selector> e) {
            super(e);
        }

        public void serialize(Selector value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField("objectType", value.objectType().name());
            if (value.objectName() != null) {
                jgen.writeObjectField("objectName", (Object)value.objectName());
            }
            if (value.schemaName() != null) {
                jgen.writeObjectField("schema", (Object)value.schemaName());
            }
            jgen.writeEndObject();
        }
    }
}

