/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.deployunit.structure.UnitEntry;

public class UnitFolder
implements UnitEntry {
    private final String name;
    private final List<UnitEntry> children = new ArrayList<UnitEntry>();

    public UnitFolder(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long size() {
        return this.children.stream().mapToLong(UnitEntry::size).sum();
    }

    public void addChild(UnitEntry entry) {
        this.children.add(entry);
    }

    public Collection<UnitEntry> children() {
        return Collections.unmodifiableCollection(this.children);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitFolder folder = (UnitFolder)o;
        return Objects.equals(this.name, folder.name) && Objects.equals(this.children, folder.children);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.children);
    }
}

