/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.loader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.ignite3.compute.ComputeException;
import org.apache.ignite3.lang.ErrorGroups;

class UnitsClasspath {
    UnitsClasspath() {
    }

    static Stream<URL> collectClasspath(Path unitDir) {
        if (Files.notExists(unitDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Unit does not exist: " + unitDir);
        }
        if (!Files.isDirectory(unitDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Unit is not a directory: " + unitDir);
        }
        try {
            ClasspathCollector classpathCollector = new ClasspathCollector(unitDir);
            Files.walkFileTree(unitDir, classpathCollector);
            return classpathCollector.classpathAsStream();
        }
        catch (IOException e) {
            throw new ComputeException(ErrorGroups.Compute.CLASS_PATH_ERR, "Failed to construct classpath for job: " + unitDir, (Throwable)e);
        }
    }

    private static class ClasspathCollector
    extends SimpleFileVisitor<Path> {
        private final List<URL> classpath = new ArrayList<URL>();

        private ClasspathCollector(Path base) throws MalformedURLException {
            this.classpath.add(base.toAbsolutePath().toUri().toURL());
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Files.isDirectory(file, new LinkOption[0]) || file.toString().endsWith(".jar")) {
                this.classpath.add(file.toAbsolutePath().toUri().toURL());
            }
            return FileVisitResult.CONTINUE;
        }

        Stream<URL> classpathAsStream() {
            return this.classpath.stream();
        }
    }
}

