/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.loader;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitNotFoundException;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitUnavailableException;
import org.apache.ignite3.internal.deployunit.loader.UnitsClassLoaderContext;
import org.apache.ignite3.internal.util.ExceptionUtils;

class ClassLoaderExceptionsMapper {
    private static final String DEPLOYMENT_UNIT_DOES_NOT_EXIST_MSG = "%s. Deployment unit %s:%s doesn't exist";
    private static final String DEPLOYMENT_UNIT_NOT_AVAILABLE_MSG = "%s. Deployment unit %s:%s can't be used: [clusterStatus = %s, nodeStatus = %s]";

    ClassLoaderExceptionsMapper() {
    }

    static CompletableFuture<UnitsClassLoaderContext> mapClassLoaderExceptions(CompletableFuture<UnitsClassLoaderContext> future, String acquireId) {
        return future.handle((v, e) -> {
            if (e != null) {
                throw new CompletionException(ClassLoaderExceptionsMapper.mapException(ExceptionUtils.unwrapCompletionThrowable(e), acquireId));
            }
            return v;
        });
    }

    private static Throwable mapException(Throwable e, String jobClassName) {
        if (e instanceof DeploymentUnitNotFoundException) {
            return new ClassNotFoundException(String.format(DEPLOYMENT_UNIT_DOES_NOT_EXIST_MSG, jobClassName, ((DeploymentUnitNotFoundException)e).id(), ((DeploymentUnitNotFoundException)e).version()));
        }
        if (e instanceof DeploymentUnitUnavailableException) {
            return new ClassNotFoundException(String.format(DEPLOYMENT_UNIT_NOT_AVAILABLE_MSG, new Object[]{jobClassName, ((DeploymentUnitUnavailableException)e).id(), ((DeploymentUnitUnavailableException)e).version(), ((DeploymentUnitUnavailableException)e).clusterStatus(), ((DeploymentUnitUnavailableException)e).nodeStatus()}));
        }
        return e;
    }
}

