/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.network.messages;

import java.util.Objects;
import org.apache.ignite3.internal.cluster.management.network.messages.NodeStopMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.NodeStopMessageBuilder;
import org.apache.ignite3.internal.cluster.management.network.messages.NodeStopMessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class NodeStopMessageImpl
implements NodeStopMessage,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 101;
    @IgniteToStringInclude
    private final String reason;

    private NodeStopMessageImpl(String reason) {
        this.reason = reason;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    public MessageSerializer serializer() {
        return NodeStopMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(NodeStopMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 101;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NodeStopMessageImpl otherMessage = (NodeStopMessageImpl)other;
        return Objects.equals(this.reason, otherMessage.reason);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.reason);
        return result;
    }

    @Override
    public NodeStopMessageImpl clone() {
        try {
            return (NodeStopMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static NodeStopMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements NodeStopMessageBuilder {
        private String reason;

        private Builder() {
        }

        @Override
        public NodeStopMessageBuilder reason(String reason) {
            Objects.requireNonNull(reason, "reason is not marked @Nullable");
            this.reason = reason;
            return this;
        }

        @Override
        public String reason() {
            return this.reason;
        }

        @Override
        public NodeStopMessage build() {
            return new NodeStopMessageImpl(Objects.requireNonNull(this.reason, "reason is not marked @Nullable"));
        }

        @Override
        public NodeStopMessage buildDeserialized() {
            return new NodeStopMessageImpl(this.reason);
        }
    }
}

