/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management;

import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.ClusterStateImpl;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesTypeInfos;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class ClusterStateSerializer
implements MessageSerializer<ClusterState> {
    public static final ClusterStateSerializer INSTANCE = new ClusterStateSerializer();

    private ClusterStateSerializer() {
    }

    @Override
    public boolean writeMessage(ClusterState msg, MessageWriter writer) throws MessageMappingException {
        ClusterStateImpl message = (ClusterStateImpl)msg;
        writer.setMessageTypeInfo(CmgMessagesTypeInfos.clusterState());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)6)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("clusterTag", message.clusterTag());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeSet("cmgNodes", message.cmgNodes(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeList("formerClusterIds", message.formerClusterIds(), MessageCollectionItemType.UUID);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("initialClusterConfiguration", message.initialClusterConfiguration());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeSet("metaStorageNodes", message.metaStorageNodes(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeString("version", message.version());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

