/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite3.client.RetryLimitPolicy;
import org.apache.ignite3.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite3.internal.client.PayloadOutputChannel;
import org.apache.ignite3.internal.client.WriteContext;
import org.apache.ignite3.internal.client.proto.TuplePart;
import org.apache.ignite3.internal.client.sql.ClientSql;
import org.apache.ignite3.internal.client.table.AbstractClientView;
import org.apache.ignite3.internal.client.table.ClientContinuousQuery;
import org.apache.ignite3.internal.client.table.ClientDataStreamer;
import org.apache.ignite3.internal.client.table.ClientNearCacheKeyImpl;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.internal.client.table.ClientSerializedTuple;
import org.apache.ignite3.internal.client.table.ClientTable;
import org.apache.ignite3.internal.client.table.ClientTuple;
import org.apache.ignite3.internal.client.table.ClientTupleSerializer;
import org.apache.ignite3.internal.client.table.MapFunction;
import org.apache.ignite3.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite3.internal.client.table.TupleStreamerPartitionAwarenessProvider;
import org.apache.ignite3.internal.streamer.StreamerBatchSender;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.Pair;
import org.apache.ignite3.internal.util.ViewUtils;
import org.apache.ignite3.table.ContinuousQueryOptions;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOptions;
import org.apache.ignite3.table.DataStreamerReceiverDescriptor;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.TableRowEventBatch;
import org.apache.ignite3.table.TableRowEventType;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheRecordRowEventSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheSchemaVersionAwareSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class ClientRecordBinaryView
extends AbstractClientView<Tuple>
implements RecordView<Tuple>,
NearCacheEntriesProvider<Tuple, Tuple, ClientSerializedTuple> {
    private final ClientTupleSerializer ser;

    ClientRecordBinaryView(ClientTable tbl, ClientSql sql) {
        super(tbl, sql);
        this.ser = new ClientTupleSerializer(tbl.tableId(), tbl::qualifiedName);
    }

    @Override
    public Tuple get(@Nullable Transaction tx, Tuple keyRec) {
        return ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    @Override
    public List<Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<List<Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, "keyRecs", "key");
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        MapFunction clo = (batch, provider, txRequired) -> {
            Transaction tx0 = this.tbl.startTxIfNeeded(tx, txns, txRequired);
            return this.tbl.doSchemaOutInOpAsync(15, (s, w, n) -> this.ser.writeTuples(tx0, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true), (s, r) -> ClientTupleSerializer.readTuplesNullable(s, r.in()), Collections.emptyList(), provider, tx0);
        };
        return this.tbl.splitAndRun(keyRecs, clo, ClientTupleSerializer::getColocationHash, txns);
    }

    @Override
    public boolean contains(@Nullable Transaction tx, Tuple key) {
        return ViewUtils.sync(this.containsAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        ArrayList<Transaction> txns = new ArrayList<Transaction>();
        MapFunction clo = (batch, provider, txRequired) -> {
            Transaction tx0 = this.tbl.startTxIfNeeded(tx, txns, txRequired);
            return this.tbl.doSchemaOutOpAsync(67, (s, w, n) -> this.ser.writeTuples(tx0, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true), r -> r.in().unpackBoolean(), provider, tx0);
        };
        return this.tbl.splitAndRun(keys, clo, Boolean.TRUE, (agg, cur) -> agg != false && cur != false, ClientTupleSerializer::getColocationHash, txns);
    }

    @Override
    public void upsert(@Nullable Transaction tx, Tuple rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    @Override
    public void upsertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        if (recs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutOpAsync(13, (s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false), r -> null, provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, null, (agg, cur) -> null, ClientTupleSerializer::getColocationHash);
    }

    @Override
    public Tuple getAndUpsert(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Tuple> getAndUpsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    @Override
    public boolean insert(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.insertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    @Override
    public List<Tuple> insertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        return ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<Tuple>> insertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(20, (s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false), (s, r) -> ClientTupleSerializer.readTuples(s, r.in()), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    @Override
    public boolean replace(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        return ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (s, w, n) -> {
            this.ser.writeTuple(tx, oldRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false, false);
            this.ser.writeTuple(tx, newRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false, true);
        }, r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(oldRec), tx);
    }

    @Override
    public Tuple getAndReplace(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    @Override
    public boolean delete(@Nullable Transaction tx, Tuple keyRec) {
        return ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    @Override
    public boolean deleteExact(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    @Override
    public Tuple getAndDelete(@Nullable Transaction tx, Tuple keyRec) {
        return ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Tuple> getAndDeleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    @Override
    public List<Tuple> deleteAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @Override
    public void deleteAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.deleteAllAsync(tx));
    }

    @Override
    public CompletableFuture<List<Tuple>> deleteAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(29, (s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true), (s, r) -> ClientTupleSerializer.readTuples(s, r.in(), true), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(keyRecs, ClientTupleSerializer.getPartitionAwarenessProvider(keyRecs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(keyRecs, clo, new ArrayList(keyRecs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name(), new Object[0]).thenApply(r -> null);
    }

    @Override
    public List<Tuple> deleteAllExact(@Nullable Transaction tx, Collection<Tuple> recs) {
        return ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<Tuple>> deleteAllExactAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        MapFunction clo = (batch, provider, txRequired) -> this.tbl.doSchemaOutInOpAsync(31, (s, w, n) -> this.ser.writeTuples(tx, batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false), (s, r) -> ClientTupleSerializer.readTuples(s, r.in()), Collections.emptyList(), provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()), false);
        }
        return this.tbl.splitAndRun(recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Tuple>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        TupleStreamerPartitionAwarenessProvider provider = new TupleStreamerPartitionAwarenessProvider(this.tbl);
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (s, w, n) -> this.ser.writeStreamerTuples((int)partitionId, items, deleted, (ClientSchema)s, (PayloadOutputChannel)w), r -> null, PartitionAwarenessProvider.of(partitionId), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    @Override
    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, Tuple> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new TupleStreamerPartitionAwarenessProvider(this.tbl), this.tbl, resultSubscriber, receiver, receiverArg);
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Tuple>> subscriber, @Nullable ContinuousQueryOptions options) {
        BiFunction<byte[], ClientSchema, Tuple> mapper = (row, schema) -> {
            int colCnt = schema.columns().length;
            BinaryTupleReader binTuple = new BinaryTupleReader(colCnt, (byte[])row);
            return new ClientTuple((ClientSchema)schema, TuplePart.KEY_AND_VAL, binTuple);
        };
        ClientContinuousQuery.queryContinuously(subscriber, options, mapper, this.tbl);
    }

    @Override
    public Class<Tuple> valueType() {
        return Tuple.class;
    }

    @Override
    public CompletableFuture<NearCacheKey<Tuple, ClientSerializedTuple>> getNearCacheKeyAsync(Tuple key, boolean enforceKeyOnly) {
        return this.tbl.getLatestSchema().thenApply(schema -> new ClientNearCacheKeyImpl<Tuple>(key, this.ser.serializeTupleRaw(key, (ClientSchema)schema, true)));
    }

    @Override
    public CompletableFuture<Collection<NearCacheKey<Tuple, ClientSerializedTuple>>> getNearCacheKeysAsync(Iterable<? extends Tuple> keys, boolean enforceKeyOnly) {
        return this.tbl.getLatestSchema().thenApply(schema -> {
            ArrayList<ClientNearCacheKeyImpl<Tuple>> serializedKeys = new ArrayList<ClientNearCacheKeyImpl<Tuple>>();
            for (Tuple key : keys) {
                serializedKeys.add(new ClientNearCacheKeyImpl<Tuple>(key, this.ser.serializeTupleRaw(key, (ClientSchema)schema, true)));
            }
            return serializedKeys;
        });
    }

    @Override
    public CompletableFuture<Pair<NearCacheKey<Tuple, ClientSerializedTuple>, NearCacheValue<Tuple>>> getNearCacheValueAsync(@Nullable Transaction tx, NearCacheKey<Tuple, ClientSerializedTuple> key) {
        Objects.requireNonNull(key, "key");
        AtomicReference serializedKey = new AtomicReference();
        return this.tbl.doSchemaOutInOpAsync(12, (s, w, n) -> {
            ClientSerializedTuple keyTuple = (ClientSerializedTuple)key.serializedKey();
            if (keyTuple == null || keyTuple.schemaVersion() != s.version()) {
                keyTuple = this.ser.serializeTupleRaw((Tuple)key.key(), (ClientSchema)s, true);
            }
            serializedKey.set(keyTuple);
            this.ser.writeTuple(tx, keyTuple, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n);
        }, (s, r) -> new Pair<ClientNearCacheKeyImpl<Tuple>, NearCacheValue<Tuple>>(new ClientNearCacheKeyImpl<Tuple>((Tuple)key.key(), (ClientSerializedTuple)serializedKey.get()), new NearCacheValue<Tuple>(ClientTupleSerializer.readTuple(s, r.in(), false))), new Pair(key, new NearCacheValue()), ClientTupleSerializer.getPartitionAwarenessProvider(key.key()), tx);
    }

    @Override
    public CompletableFuture<Map<NearCacheKey<Tuple, ClientSerializedTuple>, NearCacheValue<Tuple>>> getNearCacheValuesAsync(@Nullable Transaction tx, Collection<NearCacheKey<Tuple, ClientSerializedTuple>> nearCacheKeys) {
        ViewUtils.checkKeysForNulls(nearCacheKeys);
        if (nearCacheKeys.isEmpty()) {
            return CompletableFutures.emptyMapCompletedFuture();
        }
        PartitionAwarenessProvider provider = ClientTupleSerializer.getPartitionAwarenessProvider(nearCacheKeys.iterator().next().key());
        AtomicReference serializedKeyHolder = new AtomicReference();
        return this.tbl.doSchemaOutInOpAsync(15, (s, w, n) -> {
            ArrayList<ClientNearCacheKeyImpl> keys = new ArrayList<ClientNearCacheKeyImpl>(nearCacheKeys.size());
            ArrayList<ClientSerializedTuple> serializedTuples = new ArrayList<ClientSerializedTuple>(nearCacheKeys.size());
            for (NearCacheKey nearCacheKey : nearCacheKeys) {
                ClientSerializedTuple keyTuple = (ClientSerializedTuple)nearCacheKey.serializedKey();
                if (keyTuple == null || keyTuple.schemaVersion() != s.version()) {
                    keyTuple = this.ser.serializeTupleRaw((Tuple)nearCacheKey.key(), (ClientSchema)s, true);
                    keys.add(new ClientNearCacheKeyImpl<Tuple>((Tuple)nearCacheKey.key(), keyTuple));
                    serializedTuples.add(keyTuple);
                    continue;
                }
                keys.add((ClientNearCacheKeyImpl)nearCacheKey);
                serializedTuples.add(keyTuple);
            }
            serializedKeyHolder.set(keys);
            this.ser.writeTuples(tx, (Collection<ClientSerializedTuple>)serializedTuples, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n);
        }, (s, r) -> {
            List<Tuple> resp = ClientTupleSerializer.readTuplesNullable(s, r.in());
            List serializedKeys = (List)serializedKeyHolder.get();
            assert (resp.size() == serializedKeys.size()) : "Size of the response must match with the size of the request";
            LinkedHashMap ret = new LinkedHashMap(resp.size());
            for (int i = 0; i < serializedKeys.size(); ++i) {
                ClientNearCacheKeyImpl nearCacheKey = (ClientNearCacheKeyImpl)serializedKeys.get(i);
                Tuple val = resp.get(i);
                NearCacheValue<Object> nearCacheValue = val != null ? new NearCacheValue<Tuple>(val) : new NearCacheValue();
                ret.put(nearCacheKey, nearCacheValue);
            }
            return ret;
        }, Collections.emptyMap(), provider, tx);
    }

    @Override
    public void subscribeToNearCacheUpdates(Flow.Subscriber<TableRowEventBatch<Map.Entry<Tuple, Tuple>>> subscriber, int updateInterval) {
        ContinuousQueryOptions opts = ContinuousQueryOptions.builder().pollIntervalMs(updateInterval).eventTypes(TableRowEventType.CREATED, TableRowEventType.UPDATED, TableRowEventType.REMOVED).build();
        this.queryContinuously((Flow.Subscriber<TableRowEventBatch<Tuple>>)new NearCacheSchemaVersionAwareSubscriber<Tuple>(new NearCacheRecordRowEventSubscriber(subscriber), () -> this.tbl.getLatestSchema().thenApply(ClientSchema::version)), opts);
    }

    @Override
    public void close() throws Exception {
    }
}

