/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;

@FunctionalInterface
public interface InetAddressResolver {
    public static final InetAddressResolver DEFAULT = (host, port) -> {
        HashSet<InetSocketAddress> res = new HashSet<InetSocketAddress>();
        for (InetAddress inetAddr : InetAddress.getAllByName(host)) {
            if (inetAddr.isLoopbackAddress()) {
                res.add(InetSocketAddress.createUnresolved(host, port));
                continue;
            }
            res.add(new InetSocketAddress(inetAddr, port));
        }
        return res;
    };

    public Collection<InetSocketAddress> getAllByName(String var1, int var2) throws UnknownHostException;
}

