/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClientTransactionInflights {
    private static final int MAX_CONCURRENT_TXNS_HINT = 1024;
    private final ConcurrentHashMap<UUID, TxContext> txCtxMap = new ConcurrentHashMap(1024);

    public void addInflight(UUID txId) {
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = new TxContext();
            }
            ctx.addInflight();
            return ctx;
        });
    }

    public void removeInflight(UUID txId, @Nullable Throwable t) {
        TxContext ctx0 = this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                throw new AssertionError();
            }
            ctx.removeInflight(txId);
            if (t != null && ctx.err == null) {
                ctx.err = t;
            }
            return ctx;
        });
        if (ctx0.finishFut != null && ctx0.inflights == 0L) {
            if (t != null) {
                ctx0.finishFut.completeExceptionally(t);
            } else {
                ctx0.finishFut.complete(null);
            }
        }
    }

    public CompletableFuture<Void> finishFuture(UUID txId) {
        TxContext ctx0 = this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                return null;
            }
            if (ctx.finishFut == null) {
                ctx.finishFut = ctx.err != null ? CompletableFuture.failedFuture(ctx.err) : (ctx.inflights == 0L ? CompletableFutures.nullCompletedFuture() : new CompletableFuture());
            }
            return ctx;
        });
        if (ctx0 == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return ctx0.finishFut;
    }

    public void erase(UUID uuid) {
        this.txCtxMap.remove(uuid);
    }

    public boolean contains(UUID txId) {
        return this.txCtxMap.containsKey(txId);
    }

    @TestOnly
    public ConcurrentHashMap<UUID, TxContext> map() {
        return this.txCtxMap;
    }

    public static class TxContext {
        public CompletableFuture<Void> finishFut;
        public long inflights = 0L;
        public Throwable err;

        void addInflight() {
            ++this.inflights;
        }

        void removeInflight(UUID txId) {
            assert (this.inflights > 0L) : IgniteStringFormatter.format("No inflights, cannot remove any [txId={}, ctx={}]", txId, this);
            --this.inflights;
        }
    }
}

