/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite3.internal.cli.sql.SqlQueryResult;
import org.apache.ignite3.internal.cli.table.Table;

public class SqlManager
implements AutoCloseable {
    private final Connection connection;

    public SqlManager(String jdbcUrl) throws SQLException {
        this.connection = DriverManager.getConnection(jdbcUrl);
    }

    public SqlQueryResult execute(String sql) throws SQLException {
        SqlQueryResult.SqlQueryResultBuilder sqlQueryResultBuilder = new SqlQueryResult.SqlQueryResultBuilder();
        long startTime = System.currentTimeMillis();
        try (Statement statement = this.connection.createStatement();){
            statement.execute(sql);
            do {
                ResultSet rs;
                if ((rs = statement.getResultSet()) != null) {
                    sqlQueryResultBuilder.addTable(Table.fromResultSet(rs));
                    continue;
                }
                int updateCount = statement.getUpdateCount();
                sqlQueryResultBuilder.addMessage((String)(updateCount >= 0 ? "Updated " + updateCount + " rows." : "OK!"));
            } while (statement.getMoreResults() || statement.getUpdateCount() != -1);
            sqlQueryResultBuilder.setDurationMs(System.currentTimeMillis() - startTime);
            SqlQueryResult sqlQueryResult = sqlQueryResultBuilder.build();
            return sqlQueryResult;
        }
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    public DatabaseMetaData getMetadata() throws SQLException {
        return this.connection.getMetaData();
    }
}

