/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.rest;

import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.cli.core.rest.TokenStore;
import org.apache.ignite3.rest.client.invoker.ApiCallback;
import org.apache.ignite3.rest.client.invoker.ApiException;

public class ReAuthApiCallback<T>
implements ApiCallback<T> {
    private final TokenStore tokenStore;
    private final ApiCallback<T> callback;
    private final Runnable retryWithReAuth;

    public ReAuthApiCallback(ApiCallback<T> callback, TokenStore tokenStore, Runnable retryWithReAuth) {
        this.callback = callback;
        this.tokenStore = tokenStore;
        this.retryWithReAuth = retryWithReAuth;
    }

    @Override
    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
        if (statusCode == 401 && !this.tokenStore.isTokenPersisted()) {
            this.retryWithReAuth.run();
        } else {
            this.callback.onFailure(e, statusCode, responseHeaders);
        }
    }

    @Override
    public void onSuccess(T result, int statusCode, Map<String, List<String>> responseHeaders) {
        this.callback.onSuccess(result, statusCode, responseHeaders);
    }

    @Override
    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
        this.callback.onUploadProgress(bytesWritten, contentLength, done);
    }

    @Override
    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
        this.callback.onDownloadProgress(bytesRead, contentLength, done);
    }
}

