/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.recovery.states;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.cli.call.recovery.states.PartitionStatesCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.table.Table;
import org.apache.ignite3.rest.client.api.RecoveryApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.GlobalZonePartitionStateResponse;
import org.apache.ignite3.rest.client.model.GlobalZonePartitionStatesResponse;
import org.apache.ignite3.rest.client.model.LocalZonePartitionStateResponse;
import org.apache.ignite3.rest.client.model.LocalZonePartitionStatesResponse;

@Singleton
public class PartitionStatesCall
implements Call<PartitionStatesCallInput, Table> {
    private final ApiClientFactory clientFactory;
    private static final List<String> ZONE_GLOBAL_HEADERS = List.of("Zone name", "Partition ID", "State");
    private static final List<String> ZONE_LOCAL_HEADERS = Stream.concat(Stream.of("Node name"), ZONE_GLOBAL_HEADERS.stream()).collect(Collectors.toList());

    public PartitionStatesCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<Table> execute(PartitionStatesCallInput input) {
        RecoveryApi client = new RecoveryApi(this.clientFactory.getClient(input.clusterUrl()));
        try {
            if (input.local()) {
                return PartitionStatesCall.getLocalPartitionStatesOutput(client, input.zoneNames(), input);
            }
            return PartitionStatesCall.getGlobalPartitionStatesOutput(input, client, input.zoneNames());
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }

    private static DefaultCallOutput<Table> getGlobalPartitionStatesOutput(PartitionStatesCallInput input, RecoveryApi client, List<String> zoneNames) throws ApiException {
        GlobalZonePartitionStatesResponse globalStates = client.getZoneGlobalPartitionStates(zoneNames, input.partitionIds());
        return DefaultCallOutput.success(new Table(ZONE_GLOBAL_HEADERS, globalStates.getStates().stream().flatMap(PartitionStatesCall::globalZoneState).collect(Collectors.toList())));
    }

    private static Stream<String> globalZoneState(GlobalZonePartitionStateResponse state) {
        return Stream.of(state.getZoneName(), String.valueOf(state.getPartitionId()), state.getState());
    }

    private static DefaultCallOutput<Table> getLocalPartitionStatesOutput(RecoveryApi client, List<String> zoneNames, PartitionStatesCallInput input) throws ApiException {
        LocalZonePartitionStatesResponse localStates = client.getZoneLocalPartitionStates(zoneNames, input.nodeNames(), input.partitionIds());
        return DefaultCallOutput.success(new Table(ZONE_LOCAL_HEADERS, localStates.getStates().stream().flatMap(PartitionStatesCall::localZoneState).collect(Collectors.toList())));
    }

    private static Stream<String> localZoneState(LocalZonePartitionStateResponse state) {
        return Stream.of(state.getNodeName(), state.getZoneName(), String.valueOf(state.getPartitionId()), state.getState());
    }
}

