/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.systemviews;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.systemview.api.ClusterSystemView;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViews;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.SubscriptionUtils;

public class IndexSystemViewProvider
implements CatalogSystemViewProvider {
    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        Iterable viewData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.indexes().stream().filter(index -> index.status().isAlive()).map(index -> new IndexWithCatalog((CatalogIndexDescriptor)index, Objects.requireNonNull(catalog.table(index.tableId()), "table not found by id " + index.tableId()), catalog)).iterator();
        };
        SystemView indexView = ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("INDEXES")).addColumn("INDEX_ID", NativeTypes.INT32, entry -> entry.index.id())).addColumn("INDEX_NAME", NativeTypes.STRING, entry -> entry.index.name())).addColumn("TABLE_ID", NativeTypes.INT32, entry -> entry.index.tableId())).addColumn("TABLE_NAME", NativeTypes.STRING, entry -> entry.table.name())).addColumn("SCHEMA_ID", NativeTypes.INT32, IndexSystemViewProvider::getSchemaId)).addColumn("SCHEMA_NAME", NativeTypes.STRING, entry -> entry.catalog.schema(IndexSystemViewProvider.getSchemaId(entry)).name())).addColumn("INDEX_TYPE", NativeTypes.STRING, entry -> entry.index.indexType().name())).addColumn("IS_UNIQUE_INDEX", NativeTypes.BOOLEAN, entry -> entry.index.unique())).addColumn("INDEX_COLUMNS", NativeTypes.STRING, IndexSystemViewProvider::getColumnsString)).addColumn("INDEX_STATE", NativeTypes.STRING, entry -> entry.index.status().name())).addColumn("TYPE", NativeTypes.STRING, entry -> entry.index.indexType().name())).addColumn("IS_UNIQUE", NativeTypes.BOOLEAN, entry -> entry.index.unique())).addColumn("COLUMNS", NativeTypes.STRING, IndexSystemViewProvider::getColumnsString)).addColumn("STATUS", NativeTypes.STRING, entry -> entry.index.status().name())).dataProvider(SubscriptionUtils.fromIterable(viewData))).build();
        return List.of(indexView);
    }

    private static String getColumnsString(IndexWithCatalog entry) {
        return entry.index.indexType() == CatalogIndexDescriptor.CatalogIndexDescriptorType.HASH ? ((CatalogHashIndexDescriptor)entry.index).columnIds().intStream().mapToObj(id -> entry.table.columnById(id).name()).collect(Collectors.joining(", ")) : ((CatalogSortedIndexDescriptor)entry.index).columns().stream().map(column -> entry.table.columnById(column.columnId()).name() + (column.collation().asc() ? " ASC" : " DESC")).collect(Collectors.joining(", "));
    }

    private static int getSchemaId(IndexWithCatalog entry) {
        return entry.table.schemaId();
    }

    private static class IndexWithCatalog {
        final CatalogIndexDescriptor index;
        final CatalogTableDescriptor table;
        final Catalog catalog;

        IndexWithCatalog(CatalogIndexDescriptor index, CatalogTableDescriptor table, Catalog catalog) {
            this.index = index;
            this.table = table;
            this.catalog = catalog;
        }
    }
}

