/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.ModifyTableRowLevelSecurityEventParameters;
import org.apache.ignite3.internal.catalog.storage.AbstractUpdateTableEntry;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.tostring.S;

public class ModifyTableRowLevelSecurityEntry
extends AbstractUpdateTableEntry
implements Fireable {
    private final int tableId;
    private final boolean enableSecurity;

    public ModifyTableRowLevelSecurityEntry(int tableId, boolean enableSecurity) {
        this.tableId = tableId;
        this.enableSecurity = enableSecurity;
    }

    public boolean enableSecurity() {
        return this.enableSecurity;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.MODIFY_ROW_LEVEL_SECURITY.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new ModifyTableRowLevelSecurityEventParameters(causalityToken, catalogVersion, this.tableId, this.enableSecurity);
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        return table.copyBuilder().rowLevelSecurityEnabled(this.enableSecurity);
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public String toString() {
        return S.toString(this);
    }
}

