/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.util.Arrays;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.storage.Fireable;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public class DropMapEntry
implements UpdateEntry,
Fireable {
    private final int mapId;

    public DropMapEntry(int mapId) {
        this.mapId = mapId;
    }

    public int mapId() {
        return this.mapId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_MAP.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.MAP_DROP;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CatalogEventParameters(causalityToken, catalogVersion){};
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogMapDescriptor map = catalog.map(this.mapId);
        if (map == null) {
            throw new CatalogValidationException("Map with ID '{}' not found.", this.mapId);
        }
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, map.schemaId());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), schema.indexes(), schema.systemViews(), schema.sequences(), schema.policies(), (CatalogMapDescriptor[])Arrays.stream(schema.maps()).filter(m -> m.id() != this.mapId).toArray(CatalogMapDescriptor[]::new), schema.statistics(), timestamp), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }
}

