/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogStatisticsDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public class CatalogSchemaDescriptorSerializers {

    @CatalogSerializer(version=5, since="gridgain-9.1.16")
    static class SchemaDescriptorSerializerV5
    extends SchemaDescriptorSerializerV4 {
        SchemaDescriptorSerializerV5() {
        }

        @Override
        public CatalogSchemaDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogSchemaDescriptor descriptorV4 = super.readFrom(input);
            List<CatalogStatisticsDescriptor> statistics = input.readCompactEntryList(CatalogStatisticsDescriptor.class);
            return new CatalogSchemaDescriptor(descriptorV4.id(), descriptorV4.name(), descriptorV4.tables(), descriptorV4.indexes(), descriptorV4.systemViews(), descriptorV4.sequences(), descriptorV4.policies(), descriptorV4.maps(), statistics.toArray(new CatalogStatisticsDescriptor[0]), descriptorV4.updateTimestamp());
        }

        @Override
        public void writeTo(CatalogSchemaDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            super.writeTo(descriptor, output);
            output.writeCompactEntryList(Arrays.asList(descriptor.statistics()));
        }
    }

    @CatalogSerializer(version=4, since="gridgain-9.1.8")
    static class SchemaDescriptorSerializerV4
    extends SchemaDescriptorSerializerV3 {
        SchemaDescriptorSerializerV4() {
        }

        @Override
        public CatalogSchemaDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogSchemaDescriptor descriptorV3 = super.readFrom(input);
            List<CatalogMapDescriptor> maps = input.readCompactEntryList(CatalogMapDescriptor.class);
            return new CatalogSchemaDescriptor(descriptorV3.id(), descriptorV3.name(), descriptorV3.tables(), descriptorV3.indexes(), descriptorV3.systemViews(), descriptorV3.sequences(), descriptorV3.policies(), maps.toArray(new CatalogMapDescriptor[0]), descriptorV3.statistics(), descriptorV3.updateTimestamp());
        }

        @Override
        public void writeTo(CatalogSchemaDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            super.writeTo(descriptor, output);
            output.writeCompactEntryList(Arrays.asList(descriptor.maps()));
        }
    }

    @CatalogSerializer(version=3, since="gridgain-9.1.6")
    static class SchemaDescriptorSerializerV3
    extends SchemaDescriptorSerializerV2 {
        SchemaDescriptorSerializerV3() {
        }

        @Override
        public CatalogSchemaDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogSchemaDescriptor descriptorV2 = super.readFrom(input);
            List<CatalogTablePolicyDescriptor> policies = input.readCompactEntryList(CatalogTablePolicyDescriptor.class);
            return new CatalogSchemaDescriptor(descriptorV2.id(), descriptorV2.name(), descriptorV2.tables(), descriptorV2.indexes(), descriptorV2.systemViews(), descriptorV2.sequences(), policies.toArray(new CatalogTablePolicyDescriptor[0]), descriptorV2.updateTimestamp());
        }

        @Override
        public void writeTo(CatalogSchemaDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            super.writeTo(descriptor, output);
            output.writeCompactEntryList(Arrays.asList(descriptor.policies()));
        }
    }

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class SchemaDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogSchemaDescriptor> {
        SchemaDescriptorSerializerV2() {
        }

        @Override
        public CatalogSchemaDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp(updateTimestampLong);
            List<CatalogTableDescriptor> tables = input.readCompactEntryList(CatalogTableDescriptor.class);
            List<CatalogIndexDescriptor> indexes = input.readEntryList(CatalogIndexDescriptor.class);
            List<CatalogSystemViewDescriptor> systemViews = input.readCompactEntryList(CatalogSystemViewDescriptor.class);
            List<CatalogSequenceDescriptor> sequences = input.readCompactEntryList(CatalogSequenceDescriptor.class);
            return new CatalogSchemaDescriptor(id, name, tables.toArray(new CatalogTableDescriptor[0]), indexes.toArray(new CatalogIndexDescriptor[0]), systemViews.toArray(new CatalogSystemViewDescriptor[0]), sequences.toArray(new CatalogSequenceDescriptor[0]), updateTimestamp);
        }

        @Override
        public void writeTo(CatalogSchemaDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeCompactEntryList(Arrays.asList(descriptor.tables()));
            output.writeEntryList(Arrays.asList(descriptor.indexes()));
            output.writeCompactEntryList(Arrays.asList(descriptor.systemViews()));
            output.writeCompactEntryList(Arrays.asList(descriptor.sequences()));
        }
    }
}

