/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.util.Objects;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public abstract class CatalogIndexDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry {
    private final int tableId;
    private final boolean unique;
    private final CatalogIndexStatus status;
    private final CatalogIndexDescriptorType indexType;
    private final boolean createdWithTable;

    CatalogIndexDescriptor(CatalogIndexDescriptorType indexType, int id, String name, int tableId, boolean unique, CatalogIndexStatus status, HybridTimestamp timestamp, boolean createdWithTable) {
        super(id, CatalogObjectDescriptor.Type.INDEX, name, timestamp);
        this.indexType = indexType;
        this.tableId = tableId;
        this.unique = unique;
        this.status = Objects.requireNonNull(status, "status");
        this.createdWithTable = createdWithTable;
    }

    public int tableId() {
        return this.tableId;
    }

    public boolean unique() {
        return this.unique;
    }

    public CatalogIndexStatus status() {
        return this.status;
    }

    public CatalogIndexDescriptorType indexType() {
        return this.indexType;
    }

    public boolean isCreatedWithTable() {
        return this.createdWithTable;
    }

    public abstract CatalogIndexDescriptor upgradeIfNeeded(CatalogTableDescriptor var1);

    @Override
    public String toString() {
        return S.toString(CatalogIndexDescriptor.class, this, super.toString());
    }

    public static enum CatalogIndexDescriptorType {
        HASH(0),
        SORTED(1);

        private final int typeId;

        private CatalogIndexDescriptorType(int typeId) {
            this.typeId = typeId;
        }

        public int id() {
            return this.typeId;
        }

        public static CatalogIndexDescriptorType forId(int id) {
            switch (id) {
                case 0: {
                    return HASH;
                }
                case 1: {
                    return SORTED;
                }
            }
            throw new IllegalArgumentException("Unknown index descriptor type id: " + id);
        }
    }
}

