/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;

public abstract class AbstractSequenceCommand
implements CatalogCommand {
    protected final String schemaName;
    protected final String sequenceName;
    protected final boolean ifExists;

    AbstractSequenceCommand(String schemaName, String sequenceName, boolean ifExists) {
        this.schemaName = schemaName;
        this.sequenceName = sequenceName;
        this.ifExists = ifExists;
        this.validate();
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String sequenceName() {
        return this.sequenceName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    private void validate() {
        if (this.schemaName != null && CatalogUtils.isSystemSchema(this.schemaName)) {
            throw new CatalogValidationException(IgniteStringFormatter.format("Operations with reserved schemas are not allowed, schema: {}", this.schemaName));
        }
        CatalogParamsValidationUtils.validateIdentifier(this.schemaName, "Name of the schema");
        CatalogParamsValidationUtils.validateIdentifier(this.sequenceName, "Name of the sequence");
    }
}

