/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.ignite3.internal.catalog.Catalog;
import org.jetbrains.annotations.Nullable;

class CatalogByIndexMap {
    private final long[] keys;
    private final Catalog[] values;

    CatalogByIndexMap() {
        this(new long[0], new Catalog[0]);
    }

    private CatalogByIndexMap(long[] keys, Catalog[] values) {
        this.keys = keys;
        this.values = values;
    }

    long firstKey() {
        this.checkNotEmpty();
        return this.keys[0];
    }

    long lastKey() {
        this.checkNotEmpty();
        return this.keys[this.keys.length - 1];
    }

    Catalog firstValue() {
        this.checkNotEmpty();
        return this.values[0];
    }

    Catalog lastValue() {
        this.checkNotEmpty();
        return this.values[this.values.length - 1];
    }

    @Nullable
    Catalog get(long key) {
        int idx = Arrays.binarySearch(this.keys, key);
        return idx >= 0 ? this.values[idx] : null;
    }

    @Nullable
    Catalog floorValue(long key) {
        int idx = Arrays.binarySearch(this.keys, key);
        if (idx < 0) {
            idx = ~idx - 1;
        }
        return idx >= 0 ? this.values[idx] : null;
    }

    CatalogByIndexMap appendOrUpdate(long key, Catalog catalog) {
        int length = this.keys.length;
        if (length == 0) {
            return new CatalogByIndexMap(new long[]{key}, new Catalog[]{catalog});
        }
        int idx = Arrays.binarySearch(this.keys, key);
        assert (idx >= 0 || key > this.lastKey()) : "Keys must be inserted in ascending order [keys=" + Arrays.toString(this.keys) + ", newKey=" + key + "]";
        if (idx < 0) {
            long[] keys = Arrays.copyOf(this.keys, length + 1);
            keys[length] = key;
            Catalog[] values = Arrays.copyOf(this.values, length + 1);
            values[length] = catalog;
            return new CatalogByIndexMap(keys, values);
        }
        Catalog[] values = (Catalog[])this.values.clone();
        values[idx] = catalog;
        return new CatalogByIndexMap(this.keys, values);
    }

    CatalogByIndexMap clearHead(long keyToLeave) {
        int idx = Arrays.binarySearch(this.keys, keyToLeave);
        assert (idx >= 0);
        if (idx == 0) {
            return this;
        }
        int length = this.keys.length;
        long[] keys = Arrays.copyOfRange(this.keys, idx, length);
        Catalog[] values = Arrays.copyOfRange(this.values, idx, length);
        return new CatalogByIndexMap(keys, values);
    }

    private void checkNotEmpty() {
        if (this.keys.length == 0) {
            throw new NoSuchElementException();
        }
    }
}

