/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.app;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.cluster.management.NodeAttributesProvider;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.lang.IgniteSystemProperties;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.vault.VaultEntry;
import org.apache.ignite3.internal.vault.VaultManager;
import org.apache.ignite3.internal.version.DefaultIgniteProductVersionSource;
import org.apache.ignite3.internal.version.IgniteProductVersionSource;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.TestOnly;

public class NodePropertiesImpl
implements NodeProperties,
IgniteComponent,
NodeAttributesProvider {
    private static final IgniteLogger LOG = Loggers.forClass(NodePropertiesImpl.class);
    public static final ByteArray ZONE_BASED_REPLICATION_KEY = ByteArray.fromString("zone.based.replication");
    private final VaultManager vaultManager;
    private final IgniteProductVersionSource versionSource;
    private boolean started;
    private boolean colocationEnabled;

    public NodePropertiesImpl(VaultManager vaultManager, IgniteProductVersionSource versionSource) {
        this.vaultManager = vaultManager;
        this.versionSource = versionSource;
    }

    @TestOnly
    public NodePropertiesImpl(VaultManager vaultManager) {
        this(vaultManager, new DefaultIgniteProductVersionSource());
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.detectAndSaveColocationStatusIfNeeded();
        this.started = true;
        return CompletableFutures.nullCompletedFuture();
    }

    private void detectAndSaveColocationStatusIfNeeded() {
        String logComment;
        VaultEntry entry = this.vaultManager.get(ZONE_BASED_REPLICATION_KEY);
        if (entry != null) {
            boolean bl = this.colocationEnabled = entry.value()[0] == 1;
            if (!this.colocationEnabled) {
                throw new IgniteException(ErrorGroups.Common.UNSUPPORTED_TABLE_BASED_REPLICATION_ERR, "Table based replication is no longer supported. Downgrade back to 3.1 and copy your data to a cluster of desired version.");
            }
            logComment = "from Vault";
        } else {
            boolean freshNode;
            boolean bl = freshNode = this.vaultManager.name() == null;
            if (freshNode) {
                this.colocationEnabled = IgniteSystemProperties.colocationEnabled();
                if (!this.colocationEnabled) {
                    throw new IgniteException(ErrorGroups.Common.ILLEGAL_ARGUMENT_ERR, "Table based replication is no longer supported, consider restarting the node in zone based replication mode.");
                }
            } else {
                throw new IgniteException(ErrorGroups.Common.UNSUPPORTED_TABLE_BASED_REPLICATION_ERR, "Table based replication is no longer supported. Downgrade back to 3.1 and copy your data to a cluster of desired version.");
            }
            logComment = "from system properties on a fresh node";
            this.saveToVault(this.colocationEnabled);
        }
        LOG.info("Zone based replication: {} ({})", this.colocationEnabled, logComment);
        if (this.colocationEnabled != IgniteSystemProperties.colocationEnabled()) {
            LOG.warn("Zone based replication status configured via system properties ({}) does not match, it is ignored", IgniteSystemProperties.colocationEnabled());
        }
        if (!this.colocationEnabled) {
            LOG.warn("Zone based replication is disabled, this mode is deprecated and will be removed in a future version. Consider migrating to zone based replication (which is default now).", new Object[0]);
        }
    }

    private void saveToVault(boolean enablementStatus) {
        this.vaultManager.put(ZONE_BASED_REPLICATION_KEY, new byte[]{(byte)(enablementStatus ? 1 : 0)});
    }

    @Override
    public boolean colocationEnabled() {
        if (!this.started) {
            throw new IllegalStateException("NodeProperties not started.");
        }
        return this.colocationEnabled;
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public Map<String, String> nodeAttributes() {
        return Map.of("IGNITE_ZONE_BASED_REPLICATION", Boolean.toString(this.colocationEnabled()), "ignite.version", this.versionSource.productVersion().toString());
    }
}

