/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.deployment.version;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.deployment.version.VersionParseException;
import org.jetbrains.annotations.Nullable;

class UnitVersion
implements Version {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)(?:\\.(?<minor>\\d+))?(?:\\.(?<maintenance>\\d+))?(?:\\.(?<patch>\\d+))?(?:-(?<preRelease>[0-9A-Za-z]+))?");
    private final int major;
    private final int minor;
    private final int maintenance;
    @Nullable
    private final Integer patch;
    @Nullable
    private final String preRelease;

    UnitVersion(int major, int minor, int maintenance, @Nullable Integer patch, @Nullable String preRelease) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.patch = patch;
        this.preRelease = preRelease;
    }

    @Override
    public String render() {
        return this.toString();
    }

    public static UnitVersion parse(String rawVersion) {
        Objects.requireNonNull(rawVersion);
        try {
            Matcher matcher = VERSION_PATTERN.matcher(rawVersion);
            if (!matcher.matches()) {
                throw new VersionParseException(rawVersion, "Invalid version format");
            }
            String minor = matcher.group("minor");
            String maintenance = matcher.group("maintenance");
            String patch = matcher.group("patch");
            String preRelease = matcher.group("preRelease");
            return new UnitVersion(Integer.parseUnsignedInt(matcher.group("major")), UnitVersion.nullOrBlank(minor) ? 0 : Integer.parseUnsignedInt(minor), UnitVersion.nullOrBlank(maintenance) ? 0 : Integer.parseUnsignedInt(maintenance), UnitVersion.nullOrBlank(patch) ? null : Integer.valueOf(Integer.parseUnsignedInt(patch)), UnitVersion.nullOrBlank(preRelease) ? null : preRelease);
        }
        catch (NumberFormatException e) {
            throw new VersionParseException(rawVersion, e);
        }
    }

    private static boolean nullOrBlank(String str) {
        return str == null || str.isBlank();
    }

    @Override
    public int compareTo(Version o) {
        if (o == LATEST) {
            return -1;
        }
        UnitVersion other = (UnitVersion)o;
        int res = Integer.compare(this.major, other.major);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.minor, other.minor);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.maintenance, other.maintenance);
        if (res != 0) {
            return res;
        }
        res = UnitVersion.compareNullable(this.patch, other.patch);
        if (res != 0) {
            return res;
        }
        res = UnitVersion.compareNullable(UnitVersion.preReleaseOrder(this.preRelease), UnitVersion.preReleaseOrder(other.preRelease));
        return res;
    }

    private static int compareNullable(@Nullable Integer a, @Nullable Integer b) {
        if (a != null && b != null) {
            return Integer.compare(a, b);
        }
        if (a != null) {
            return 1;
        }
        if (b != null) {
            return -1;
        }
        return 0;
    }

    @Nullable
    private static Integer preReleaseOrder(@Nullable String preRelease) {
        if (preRelease == null) {
            return null;
        }
        switch (preRelease.toLowerCase()) {
            case "alpha": {
                return 0;
            }
            case "beta": {
                return 1;
            }
            case "rc": {
                return 2;
            }
            case "final": 
            case "": {
                return 3;
            }
        }
        return 4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitVersion that = (UnitVersion)o;
        return this.major == that.major && this.minor == that.minor && this.maintenance == that.maintenance && Objects.equals(this.patch, that.patch) && Objects.equals(this.preRelease, that.preRelease);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.maintenance, this.patch, this.preRelease);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(".").add(String.valueOf(this.major)).add(String.valueOf(this.minor)).add(String.valueOf(this.maintenance));
        if (this.patch != null) {
            joiner.add(this.patch.toString());
        }
        return joiner + (String)(this.preRelease == null ? "" : "-" + this.preRelease);
    }
}

